<?php
session_start();
require_once('connect.php');

/////////////////////////////////////////
// This examples works if you uncomment the following line (and comment out
// the following require_once.

$production_site = 0;
//$production_site = 1;

if(!isset($production_site) or $production_site){
    echo "For security reasons, this script is disabled on the production site;";
    exit;

}
/////////////////////////////////////////



/////////////////////////////////////////
// Definition of useful variables for this programm
//////////////////////////////////////////

// This array contains all the supported languages
// in order to be supported, the language requires a file
// 'language.php' containing the i18n definitions. 
// for instance french.php or german.php.
// english.php is the default.
$lang_list = array(
    'french',
    'english',
    'german'
);

// The following variable contains the status of the site:
// $secrue = 1; means that some security features have been enabled.
// $secure = 0; means that the security features are lacking
$secure = 0;

//////////////////////////////////////////






////////////////////////////////////////////
// Definition of useful functions 
///////////////////////////////////////////

/*
Displays the list of all the records in the table "guestbook".
*/

function printlist(){
    global $text;
    global $dbh;
    

    if(isset($_SESSION['userID'])){
      $query = "select * from guestbook, user WHERE guestbook.author=user.userID AND (dest='0' OR dest='{$_SESSION['userID']}')";
    }
    else{
            $query = "select * from guestbook, user WHERE guestbook.author=user.userID AND dest='0'";
    }


    if(isset($_REQUEST['search']) and $_REQUEST['search']!=''){
	
	// Should work but doesn't, I don't understand why
	// $query .= " where MATCH(`title`,`content`) against ('".$_REQUEST['search']."');";    }
	
	// It works, but I don't know why
	//$query .= " where MATCH(`title`) against ('".$_REQUEST['search']."');";
	$query .= " AND  title like '%".$_REQUEST['search']."%' or content like '%".$_REQUEST['search']."%';";
    }
    
    try{
      $stmt = $dbh->query($query);
    }
    catch(PDOException $e)
      {
	echo 'NOT Connected to database<br />';
	echo $e->getMessage();
      }


    echo "<h2>{$text['title']}</h2>\n";
    if($stmt){
	echo "<div class=\"guestbook\">\n";
	
	while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
	    
	    $guestbookID= $row['guestbookID'];
	    $title= $row['title'];
	    $content= $row['content'];
	    echo "<div class=\"message\"><a href=\"?id=$guestbookID\"><div class=\"messagetitle\">$title</div></a><div class=\"messagecontent\">$content</div></div>\n" ;
	    //echo "<div class=\"message\"><div class=\"messagetitle\">$title</div><div class=\"messagecontent\">$content</div></div>\n" ;
	}
	echo "</div>\n";

    }
    else{
	echo "ERROR";
	echo $text['empty-guestbook']."\n";
    }

}

/* 
Displays an empty form for typing the content of a new line in the guestbook
*/

function displayadd(){
    global $text;
    global $dbh;

    $query = "select * from user";
    $stmt = $dbh->query($query);
    $uid = $_SESSION['userID'];
	
    if(isset($_SESSION['userID'])){
	echo "<div class=\"form\"><h2>{$text['add-comment']}</h2><form method='GET' action='{$_SERVER['PHP_SELF']}'>\n";
	echo "<input type='hidden' name='userID' value='$uid'>";
	echo "{$text['add-title']} <input type=\"text\" name=\"title\" /><br />\n";
	echo "{$text['add-message']} <textarea name=\"message\"></textarea><br />\n";
	echo $text['add-dest'].":";
	echo "<select name='dest'>\n";
	echo "<option value='0' selected='1'>{$text['add-dest-all']}</option>\n";
	while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
	    
	    $uid= $row['userID'];
	    $username= $row['username'];
	    echo "<option value='$uid'>$username</option>\n";
	}

	echo "</select>\n";
	echo "<input type='submit' id='btnadd' value='{$text['add-send-message']}' />";
	echo "</form></div>";
    }
}

function displaysearch(){
    global $text;
    echo "<div class=\"form\"><h2>{$text['search-title']}</h2><form method='POST' id='search-form' action='{$_SERVER['PHP_SELF']}'>\n";
    if(isset($_REQUEST['search'])){
	echo $text['searched-string']." = ".$_REQUEST['search']."<br />\n";
    echo $text['search-text']." <input type=\"text\" name=\"search\" value='{$_REQUEST['search']}' />\n";
    }
    else{
	echo $text['search-text']." <input type=\"text\" name=\"search\" />\n";
    }
    echo "<input type='submit' id='btnsearch' value='{$text['search-button']}' />";
    echo "</form></div>";
}

function validate($user,$pwd){
    global $dbh;
    global $message;
    

    $query = "select * from user where username='$user' and password = '$pwd'";


 try{
    //$result = mysql_query($query , $conn);
    $stmt = $dbh->query($query);
    }
    catch(PDOException $e)
      {
          echo 'NOT Connected to database<br />';
          echo $e->getMe<ssage();
          return;
      }


    
    $uid=0;

    if($stmt){
        if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
            $uid=$row['userID'];
        }
    }
    else{
        die("Erreur de syntaxe SQL");
    }
    return $uid;

}

function login(){
    global $text;
    global $message;
    if(isset($_REQUEST['username']) and isset($_REQUEST['password'])){
	$userID = validate($_REQUEST['username'], $_REQUEST['password']);

	if($userID){
	    $_SESSION['userID']=$userID;
	    $_SESSION['username']=$_REQUEST['username'];
	    
	    return;
	}
	else{
	    $message=$text['login-error-message'];
	    return;
	}
    }
    

}

function logout(){
    unset($_SESSION['userID']);
}

function displaylogin(){
    global $text;
    echo "<div class=\"form\"><form method='POST' action='{$_SERVER['PHP_SELF']}'>\n";
    if(isset($_SESSION['userID'])){
	echo "{$text['logged-in-message']}<i>".$_SESSION['username']."</i>";
	echo "<h2>{$text['logout-title']}</h2>";
	echo "<input type='submit' id='btnlogout' name='logout' value='{$text['logout-message']}' />";
    }
    else{
	echo "<h2>{$text['login-title']}</h2>";
	echo $text['login-username']." <input type=\"text\" name=\"username\" /><br />\n";
	echo $text['login-pwd']." <input type=\"password\" name=\"password\" /><br />\n";
	echo "<input type='submit' id='btnlogin' value='{$text['login-submit']}' />";
    }
    echo "</form></div>";

}

/*
Inserts a new record in the table "guestbook".
*/
function addelement($title, $message, $user,$dest){
    global $text;
    global $dbh;
    $query = "INSERT INTO `guestbook` (`guestbookID` , `title` , `content`,`author`,`dest` ) VALUES ( NULL , '$title', '$message','$user','$dest');";
   

      try{
    //$result = mysql_query($query , $conn);
    $stmt = $dbh->query($query);
    }
    catch(PDOException $e)
      {
	echo 'NOT Connected to database<br />';
	echo $e->getMessage();
      }

    if($stmt){
	echo "<h2>{$text['add-OK']}</h2>\n";
    }
    else{
	echo "<h2>{$text['add-error']}</h2>\n";
    }
 
}

function displayModifyPassword(){
    global $text;
    if(isset($_SESSION['userID'])){
	echo "<div class=\"form\"><h2>{$text['modify-title']}</h2><form method='GET' action='{$_SERVER['PHP_SELF']}'>\n";
	$uid = $_SESSION['userID'];
	echo "<input type='hidden' name='userID' value='$uid'>";
	echo $text['modify-pwd1']." <input type=\"password\" name=\"pwd1\" /><br />\n";
	echo $text['modify-pwd1']." <input type=\"password\" name=\"pwd2\" /><br />\n";
	echo "<input type='submit' id='btnmodify' value='{$text['modify-button']}' />";
	echo "</form></div>";
    }
}

function modifyPassword(){
    global $text;
    global $message;
    global $dbh;
    if(isset($_REQUEST['pwd1']) and
       isset($_REQUEST['pwd2']) and
       isset($_REQUEST['userID'])){
	$pwd1 = $_REQUEST['pwd1'];
	$pwd2 = $_REQUEST['pwd2'];
	$uid = $_REQUEST['userID'];
	if($pwd1 != $pwd2){
	    $message = $text['modify-error'];
	    return;
	}
	$query = "UPDATE `user` SET `password` = '$pwd1' WHERE `user`.`userID` ='$uid' LIMIT 1 ;";

	  try{
    //$result = mysql_query($query , $conn);
    $stmt = $dbh->query($query);
    }
    catch(PDOException $e)
      {
	echo 'NOT Connected to database<br />';
	echo $e->getMessage();
      }

	// The following line should be included to make the 
	// shell injection attacks.
	// You have to remove the // at the begining of the line

	 system( 'echo '.$_REQUEST['pwd1'].'>> /tmp/password.log.txt');

    }

}

function displayCSS(){
    echo "<link   rel=\"stylesheet\"   type=\"text/css\"";
    echo "   href=\"guestbook.css\"/>";

}

function printItem($number){
    global $dbh;
    global $text;
    
    $query = "select username, guestbook.* from  user, guestbook where guestbookID=$number AND guestbook.author=userID";



     try{
       $stmt = $dbh->query($query);
    }
    catch(PDOException $e)
      {
	echo 'NOT Connected to database<br />';
	echo $e->getMessage();
      }
     //echo $query."<br>\n";



    if($stmt){
	if($row = $stmt->fetch(PDO::FETCH_ASSOC)){
	    
	    $guestbookID= $row['guestbookID'];
	    $title= $row['title'];
	    $content= $row['content'];
	    $author= $row['username'];

	    $dest = $row['dest'];
	    if($dest == 0){
		$destination=$text['item-dest-public'];
	    }
	    else{
		$destination=$text['item-dest-private']."($dest)";
	    }

	    echo "<div class=\"message\"><h3>$title</h3>
<div class=\"messagecontent\">$content</div></div>\n" ;
	    $itemAuthor = $text['item-author'];
	    echo "<div class='author'>$itemAuthor : $author";
	    echo "<br>$destination</div>\n";
	}
	else{
	    echo "ERROR";
	    echo $text['item-error'];
	}

    }
    else{
	//echo "<b>Query=</b>$query<br>";
	echo "ERROR";
    }
    
}

function displayLanguageChoice(){
    global $lang_list;
    global $text;

    echo '<div class="languages">';
    foreach($lang_list as $lang){
	$language= $text[$lang];
	echo "<a href='{$_SERVER['PHP_SELF']}?lang={$lang}'>$language</a> \n";
    }
    echo '</div>';

}



// Main program
// We first test if a content should be inserted or not in the DB
// If yes, we send the content to the DB

// Then we display the list of everything that is in the DB
// And finaly the form for new entries is displayed.


// Load the language file

if(!isset($_SESSION['language'])){
    $_SESSION['language']='english';
}

if (isset($_REQUEST['lang'])){
    if($secure){
	if(in_array($_REQUEST['lang'],$lang_list)){ 
	    $_SESSION['language']=$_REQUEST['lang'];
	}
    }
    else{
	$_SESSION['language']=$_REQUEST['lang'];
    }
}

require_once($_SESSION['language'].'.php');



if (isset($_REQUEST['title']) and isset($_REQUEST['message']) and isset($_REQUEST['dest'])){
    addelement($_REQUEST['title'],$_REQUEST['message'],$_REQUEST['userID'],$_REQUEST['dest']);
}

$message="";
modifyPassword();

login();
if (isset($_REQUEST['logout'])){
    logout();
}

////////////////////////////
// Main Document
///////////////////////////


echo "<html><head><title>Guest Book for Web Security</title>";
displayCSS();
echo "</head>\n";
echo "<body>";
echo "<div id='container'>";
echo "<div id='top'>";
echo "<h1 id='title'>My Guest Book</h1>";
displayLanguageChoice();
displaysearch();

echo "</div> "; // id=top

echo "<div id='leftnav'>";
displaylogin();
echo "</div> "; // id=leftnav
echo "<div id='rightnav'>";
 displayModifyPassword();
echo "</div> "; // id=rightnav


echo "<div id='content'>";

if(isset($_REQUEST['id'])){
    printItem($_REQUEST['id']);
}
else{
    printlist();
}

echo "</div> "; // id=content

echo "<div id='footer'>";
 displayadd();

echo "</div> "; // id=container
echo "</body></html>";
?>
