/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationCase;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.shared_impl.util.HashMapUtils;
import org.apache.myfaces.shared_impl.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHandlerImpl
extends ConfigurableNavigationHandler {
    private static final Logger log = Logger.getLogger(NavigationHandlerImpl.class.getName());
    private static final String ASTERISK = "*";
    private Map<String, Set<NavigationCase>> _navigationCases = null;
    private List<String> _wildcardKeys = new ArrayList<String>();

    public NavigationHandlerImpl() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New NavigationHandler instance created");
        }
    }

    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        NavigationCase navigationCase = this.getNavigationCase(facesContext, fromAction, outcome);
        if (navigationCase != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("handleNavigation fromAction=" + fromAction + " outcome=" + outcome + " toViewId =" + navigationCase.getToViewId(facesContext) + " redirect=" + navigationCase.isRedirect());
            }
            if (navigationCase.isRedirect()) {
                ExternalContext externalContext = facesContext.getExternalContext();
                ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                String toViewId = navigationCase.getToViewId(facesContext);
                String redirectPath = viewHandler.getRedirectURL(facesContext, toViewId, navigationCase.getParameters(), navigationCase.isIncludeViewParams());
                PartialViewContext partialViewContext = facesContext.getPartialViewContext();
                if (partialViewContext.isPartialRequest() && !partialViewContext.isRenderAll() && !facesContext.getViewRoot().getViewId().equals(toViewId)) {
                    partialViewContext.setRenderAll(true);
                }
                externalContext.getFlash().setRedirect(true);
                try {
                    externalContext.redirect(redirectPath);
                    facesContext.responseComplete();
                }
                catch (IOException e) {
                    throw new FacesException(e.getMessage(), (Throwable)e);
                }
            } else {
                ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                String newViewId = navigationCase.getToViewId(facesContext);
                PartialViewContext partialViewContext = facesContext.getPartialViewContext();
                if (partialViewContext.isPartialRequest() && !partialViewContext.isRenderAll() && !facesContext.getViewRoot().getViewId().equals(newViewId)) {
                    partialViewContext.setRenderAll(true);
                }
                UIViewRoot viewRoot = viewHandler.createView(facesContext, newViewId);
                facesContext.setViewRoot(viewRoot);
                facesContext.renderResponse();
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("handleNavigation fromAction=" + fromAction + " outcome=" + outcome + " no matching navigation-case found, staying on current ViewRoot");
        }
    }

    public NavigationCase getNavigationCase(FacesContext facesContext, String fromAction, String outcome) {
        String viewId = facesContext.getViewRoot().getViewId();
        Map<String, Set<NavigationCase>> casesMap = this.getNavigationCases();
        NavigationCase navigationCase = null;
        Set<NavigationCase> casesSet = casesMap.get(viewId);
        if (casesSet != null) {
            navigationCase = this.calcMatchingNavigationCase(facesContext, casesSet, fromAction, outcome);
        }
        if (navigationCase == null) {
            for (String fromViewId : this.getSortedWildcardKeys()) {
                if (fromViewId.length() > 2) {
                    String prefix = fromViewId.substring(0, fromViewId.length() - 1);
                    if (viewId == null || !viewId.startsWith(prefix) || (casesSet = casesMap.get(fromViewId)) == null || (navigationCase = this.calcMatchingNavigationCase(facesContext, casesSet, fromAction, outcome)) == null) continue;
                    break;
                }
                casesSet = casesMap.get(fromViewId);
                if (casesSet == null || (navigationCase = this.calcMatchingNavigationCase(facesContext, casesSet, fromAction, outcome)) == null) continue;
                break;
            }
        }
        if (outcome != null && navigationCase == null) {
            navigationCase = this.getOutcomeNavigationCase(facesContext, fromAction, outcome);
        }
        if (outcome != null && navigationCase == null && !facesContext.isProjectStage(ProjectStage.Production)) {
            FacesMessage facesMessage = new FacesMessage("No navigation case match for viewId " + viewId + ",  action " + fromAction + " and outcome " + outcome);
            facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
            facesContext.addMessage(null, facesMessage);
        }
        return navigationCase;
    }

    private NavigationCase getOutcomeNavigationCase(FacesContext facesContext, String fromAction, String outcome) {
        String implicitViewId = null;
        boolean includeViewParams = false;
        boolean isRedirect = false;
        String queryString = null;
        NavigationCase result = null;
        String viewId = facesContext.getViewRoot().getViewId();
        String viewIdToTest = outcome;
        int index = viewIdToTest.indexOf("?");
        if (index != -1) {
            queryString = viewIdToTest.substring(index + 1);
            viewIdToTest = viewIdToTest.substring(0, index);
            if (queryString.indexOf("faces-redirect=true") != -1) {
                isRedirect = true;
            }
            if (queryString.indexOf("includeViewParams=true") != -1 || queryString.indexOf("faces-include-view-params=true") != -1) {
                includeViewParams = true;
            }
        }
        if ((index = viewIdToTest.indexOf(".")) == -1 && (index = viewId.lastIndexOf(".")) != -1) {
            viewIdToTest = viewIdToTest + viewId.substring(index);
        }
        if (!viewIdToTest.startsWith("/")) {
            index = viewId.lastIndexOf("/");
            viewIdToTest = index == -1 ? "/" + viewIdToTest : viewId.substring(0, index + 1) + viewIdToTest;
        }
        try {
            implicitViewId = facesContext.getApplication().getViewHandler().deriveViewId(facesContext, viewIdToTest);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        if (implicitViewId != null) {
            HashMap<String, ArrayList<String>> params = null;
            if (queryString != null && !"".equals(queryString)) {
                String[] splitQueryParams = queryString.split("&(amp;)?");
                params = new HashMap<String, ArrayList<String>>();
                for (String queryParam : splitQueryParams) {
                    String[] splitParam = StringUtils.splitShortString(queryParam, '=');
                    if (splitParam.length == 2) {
                        if ("includeViewParams".equals(splitParam[0]) || "faces-include-view-params".equals(splitParam[0]) || "faces-redirect".equals(splitParam[0])) continue;
                        ArrayList<String> paramValues = (ArrayList<String>)params.get(splitParam[0]);
                        if (paramValues == null) {
                            paramValues = new ArrayList<String>();
                            params.put(splitParam[0], paramValues);
                        }
                        paramValues.add(splitParam[1]);
                        continue;
                    }
                    throw new FacesException("Invalid parameter \"" + queryParam + "\" in outcome " + outcome);
                }
            }
            result = new NavigationCase(viewId, fromAction, outcome, null, implicitViewId, params, isRedirect, includeViewParams);
        }
        return result;
    }

    public String getViewId(FacesContext context, String fromAction, String outcome) {
        return this.getNavigationCase(context, fromAction, outcome).getToViewId(context);
    }

    public String beforeNavigation(String viewId) {
        return null;
    }

    private NavigationCase calcMatchingNavigationCase(FacesContext context, Set<? extends NavigationCase> casesList, String actionRef, String outcome) {
        NavigationCase noConditionCase = null;
        NavigationCase firstCase = null;
        NavigationCase secondCase = null;
        NavigationCase thirdCase = null;
        NavigationCase fourthCase = null;
        for (NavigationCase navigationCase : casesList) {
            boolean ifMatches;
            String cazeOutcome = navigationCase.getFromOutcome();
            String cazeActionRef = navigationCase.getFromAction();
            Boolean cazeIf = navigationCase.getCondition(context);
            boolean bl = ifMatches = cazeIf == null ? false : cazeIf;
            if (outcome == null && (cazeOutcome != null || cazeIf == null) && actionRef == null) continue;
            if (cazeOutcome == null && cazeActionRef == null && cazeIf == null && noConditionCase == null && outcome != null) {
                noConditionCase = navigationCase;
            }
            if (cazeActionRef != null) {
                if (cazeOutcome != null) {
                    if (actionRef != null && outcome != null && cazeActionRef.equals(actionRef) && cazeOutcome.equals(outcome)) {
                        if (cazeIf != null) {
                            if (!ifMatches) continue;
                            firstCase = navigationCase;
                            continue;
                        }
                        firstCase = navigationCase;
                    }
                } else if (actionRef != null && cazeActionRef.equals(actionRef)) {
                    if (cazeIf != null) {
                        if (!ifMatches) continue;
                        thirdCase = navigationCase;
                        continue;
                    }
                    if (outcome == null) continue;
                    thirdCase = navigationCase;
                    continue;
                }
            } else if (cazeOutcome != null && outcome != null && cazeOutcome.equals(outcome)) {
                if (cazeIf != null) {
                    if (!ifMatches) continue;
                    secondCase = navigationCase;
                    continue;
                }
                secondCase = navigationCase;
            }
            if (outcome != null && cazeIf != null) {
                if (!ifMatches) continue;
                fourthCase = navigationCase;
                continue;
            }
            if (cazeIf == null || !ifMatches) continue;
            fourthCase = navigationCase;
        }
        if (firstCase != null) {
            return firstCase;
        }
        if (secondCase != null) {
            return secondCase;
        }
        if (thirdCase != null) {
            return thirdCase;
        }
        if (fourthCase != null) {
            return fourthCase;
        }
        return noConditionCase;
    }

    private List<String> getSortedWildcardKeys() {
        return this._wildcardKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<NavigationCase>> getNavigationCases() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        if (this._navigationCases == null || runtimeConfig.isNavigationRulesChanged()) {
            NavigationHandlerImpl navigationHandlerImpl = this;
            synchronized (navigationHandlerImpl) {
                if (this._navigationCases == null || runtimeConfig.isNavigationRulesChanged()) {
                    Collection<NavigationRule> rules = runtimeConfig.getNavigationRules();
                    int rulesSize = rules.size();
                    HashMap<String, Set<NavigationCase>> cases = new HashMap<String, Set<NavigationCase>>(HashMapUtils.calcCapacity(rulesSize));
                    ArrayList<String> wildcardKeys = new ArrayList<String>();
                    for (NavigationRule rule : rules) {
                        String fromViewId = rule.getFromViewId();
                        fromViewId = fromViewId == null ? ASTERISK : fromViewId.trim();
                        HashSet<NavigationCase> set = (HashSet<NavigationCase>)cases.get(fromViewId);
                        if (set == null) {
                            set = new HashSet<NavigationCase>(this.convertNavigationCasesToAPI(rule));
                            cases.put(fromViewId, set);
                            if (!fromViewId.endsWith(ASTERISK)) continue;
                            wildcardKeys.add(fromViewId);
                            continue;
                        }
                        set.addAll(this.convertNavigationCasesToAPI(rule));
                    }
                    Collections.sort(wildcardKeys, new KeyComparator());
                    HashMap<String, Set<NavigationCase>> hashMap = cases;
                    synchronized (hashMap) {
                        this._navigationCases = cases;
                        this._wildcardKeys = wildcardKeys;
                        runtimeConfig.setNavigationRulesChanged(false);
                    }
                }
            }
        }
        return this._navigationCases;
    }

    private Set<NavigationCase> convertNavigationCasesToAPI(NavigationRule rule) {
        Collection<? extends org.apache.myfaces.config.element.NavigationCase> configCases = rule.getNavigationCases();
        HashSet<NavigationCase> apiCases = new HashSet<NavigationCase>(configCases.size());
        for (org.apache.myfaces.config.element.NavigationCase navigationCase : configCases) {
            if (navigationCase.getRedirect() != null) {
                String includeViewParamsAttribute = navigationCase.getRedirect().getIncludeViewParams();
                boolean includeViewParams = false;
                if (includeViewParamsAttribute != null) {
                    includeViewParams = new Boolean(includeViewParamsAttribute);
                }
                apiCases.add(new NavigationCase(rule.getFromViewId(), navigationCase.getFromAction(), navigationCase.getFromOutcome(), navigationCase.getIf(), navigationCase.getToViewId(), navigationCase.getRedirect().getViewParams(), true, includeViewParams));
                continue;
            }
            apiCases.add(new NavigationCase(rule.getFromViewId(), navigationCase.getFromAction(), navigationCase.getFromOutcome(), navigationCase.getIf(), navigationCase.getToViewId(), null, false, false));
        }
        return apiCases;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyComparator
    implements Comparator<String> {
        private KeyComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return -s1.compareTo(s2);
        }
    }
}

