/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UniqueIdVendor;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.FaceletFactory;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceletCompositionContextImpl
extends FaceletCompositionContext {
    private FacesContext _facesContext;
    private FaceletFactory _factory;
    private LinkedList<UIComponent> _compositeComponentStack;
    private LinkedList<UniqueIdVendor> _uniqueIdVendorStack;
    private LinkedList<String> _validationGroupsStack;
    private LinkedList<String> _excludedValidatorIdsStack;
    private LinkedList<String> _enclosingValidatorIdsStack;
    private Boolean _isRefreshingTransientBuild;
    private Boolean _isMarkInitialState;
    private Boolean _refreshTransientBuildOnPSS;
    private Boolean _usingPSSOnThisView;
    private List<Map<String, UIComponent>> _componentsMarkedForDeletion;
    private int _deletionLevel;
    private final Map<UIComponent, List<AttachedObjectHandler>> _attachedObjectHandlers;
    private static final String VIEWROOT_FACELET_ID = "oam.VIEW_ROOT";

    public FaceletCompositionContextImpl(FaceletFactory factory, FacesContext facesContext) {
        this._factory = factory;
        this._facesContext = facesContext;
        this._attachedObjectHandlers = new HashMap<UIComponent, List<AttachedObjectHandler>>();
        this._componentsMarkedForDeletion = new ArrayList<Map<String, UIComponent>>();
        this._deletionLevel = -1;
    }

    @Override
    public FaceletFactory getFaceletFactory() {
        return this._factory;
    }

    @Override
    public void release(FacesContext facesContext) {
        super.release(facesContext);
        this._factory = null;
        this._facesContext = null;
        this._compositeComponentStack = null;
        this._enclosingValidatorIdsStack = null;
        this._excludedValidatorIdsStack = null;
        this._uniqueIdVendorStack = null;
        this._validationGroupsStack = null;
        this._componentsMarkedForDeletion = null;
    }

    @Override
    public UIComponent getCompositeComponentFromStack() {
        if (this._compositeComponentStack != null && !this._compositeComponentStack.isEmpty()) {
            return this._compositeComponentStack.peek();
        }
        return null;
    }

    @Override
    public void pushCompositeComponentToStack(UIComponent parent) {
        if (this._compositeComponentStack == null) {
            this._compositeComponentStack = new LinkedList();
        }
        this._compositeComponentStack.addFirst(parent);
    }

    @Override
    public void popCompositeComponentToStack() {
        if (this._compositeComponentStack != null && !this._compositeComponentStack.isEmpty()) {
            this._compositeComponentStack.removeFirst();
        }
    }

    @Override
    public UniqueIdVendor getUniqueIdVendorFromStack() {
        if (this._uniqueIdVendorStack != null && !this._uniqueIdVendorStack.isEmpty()) {
            return this._uniqueIdVendorStack.peek();
        }
        return null;
    }

    @Override
    public void popUniqueIdVendorToStack() {
        if (this._uniqueIdVendorStack != null && !this._uniqueIdVendorStack.isEmpty()) {
            this._uniqueIdVendorStack.removeFirst();
        }
    }

    @Override
    public void pushUniqueIdVendorToStack(UniqueIdVendor parent) {
        if (this._uniqueIdVendorStack == null) {
            this._uniqueIdVendorStack = new LinkedList();
        }
        this._uniqueIdVendorStack.addFirst(parent);
    }

    @Override
    public String getFirstValidationGroupFromStack() {
        if (this._validationGroupsStack != null && !this._validationGroupsStack.isEmpty()) {
            return this._validationGroupsStack.getFirst();
        }
        return null;
    }

    @Override
    public void popValidationGroupsToStack() {
        if (this._validationGroupsStack != null && !this._validationGroupsStack.isEmpty()) {
            this._validationGroupsStack.removeFirst();
        }
    }

    @Override
    public void pushValidationGroupsToStack(String validationGroups) {
        if (this._validationGroupsStack == null) {
            this._validationGroupsStack = new LinkedList();
        }
        this._validationGroupsStack.addFirst(validationGroups);
    }

    @Override
    public Iterator<String> getExcludedValidatorIds() {
        if (this._excludedValidatorIdsStack != null && !this._excludedValidatorIdsStack.isEmpty()) {
            return this._excludedValidatorIdsStack.iterator();
        }
        return null;
    }

    @Override
    public void popExcludedValidatorIdToStack() {
        if (this._excludedValidatorIdsStack != null && !this._excludedValidatorIdsStack.isEmpty()) {
            this._excludedValidatorIdsStack.removeFirst();
        }
    }

    @Override
    public void pushExcludedValidatorIdToStack(String validatorId) {
        if (this._excludedValidatorIdsStack == null) {
            this._excludedValidatorIdsStack = new LinkedList();
        }
        this._excludedValidatorIdsStack.addFirst(validatorId);
    }

    @Override
    public Iterator<String> getEnclosingValidatorIds() {
        if (this._enclosingValidatorIdsStack != null && !this._enclosingValidatorIdsStack.isEmpty()) {
            return this._enclosingValidatorIdsStack.iterator();
        }
        return null;
    }

    @Override
    public void popEnclosingValidatorIdToStack() {
        if (this._enclosingValidatorIdsStack != null && !this._enclosingValidatorIdsStack.isEmpty()) {
            this._enclosingValidatorIdsStack.removeFirst();
        }
    }

    @Override
    public void pushEnclosingValidatorIdToStack(String validatorId) {
        if (this._enclosingValidatorIdsStack == null) {
            this._enclosingValidatorIdsStack = new LinkedList();
        }
        this._enclosingValidatorIdsStack.addFirst(validatorId);
    }

    @Override
    public boolean isRefreshingTransientBuild() {
        if (this._isRefreshingTransientBuild == null) {
            this._isRefreshingTransientBuild = FaceletViewDeclarationLanguage.isRefreshingTransientBuild(this._facesContext);
        }
        return this._isRefreshingTransientBuild;
    }

    @Override
    public boolean isMarkInitialState() {
        if (this._isMarkInitialState == null) {
            this._isMarkInitialState = FaceletViewDeclarationLanguage.isMarkInitialState(this._facesContext);
        }
        return this._isMarkInitialState;
    }

    @Override
    public boolean isRefreshTransientBuildOnPSS() {
        if (this._refreshTransientBuildOnPSS == null) {
            this._refreshTransientBuildOnPSS = FaceletViewDeclarationLanguage.isRefreshTransientBuildOnPSS(this._facesContext);
        }
        return this._refreshTransientBuildOnPSS;
    }

    @Override
    public boolean isUsingPSSOnThisView() {
        if (this._usingPSSOnThisView == null) {
            this._usingPSSOnThisView = FaceletViewDeclarationLanguage.isUsingPSSOnThisView(this._facesContext);
        }
        return this._usingPSSOnThisView;
    }

    @Override
    public boolean isMarkInitialStateAndIsRefreshTransientBuildOnPSS() {
        return this.isMarkInitialState() && this.isRefreshTransientBuildOnPSS();
    }

    @Override
    public void addAttachedObjectHandler(UIComponent compositeComponentParent, AttachedObjectHandler handler) {
        List<AttachedObjectHandler> list = this._attachedObjectHandlers.get(compositeComponentParent);
        if (list == null) {
            list = new ArrayList<AttachedObjectHandler>();
            this._attachedObjectHandlers.put(compositeComponentParent, list);
        }
        list.add(handler);
    }

    @Override
    public void removeAttachedObjectHandlers(UIComponent compositeComponentParent) {
        this._attachedObjectHandlers.remove(compositeComponentParent);
    }

    @Override
    public List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent compositeComponentParent) {
        return this._attachedObjectHandlers.get(compositeComponentParent);
    }

    private void increaseComponentLevelMarkedForDeletion() {
        ++this._deletionLevel;
        if (this._componentsMarkedForDeletion.size() <= this._deletionLevel) {
            this._componentsMarkedForDeletion.add(new HashMap());
        }
    }

    private void decreaseComponentLevelMarkedForDeletion() {
        if (!this._componentsMarkedForDeletion.get(this._deletionLevel).isEmpty()) {
            this._componentsMarkedForDeletion.get(this._deletionLevel).clear();
        }
        --this._deletionLevel;
    }

    private void markComponentForDeletion(String id, UIComponent component) {
        this._componentsMarkedForDeletion.get(this._deletionLevel).put(id, component);
    }

    private UIComponent removeComponentForDeletion(String id) {
        UIComponent removedComponent = this._componentsMarkedForDeletion.get(this._deletionLevel).remove(id);
        if (removedComponent != null && this._deletionLevel > 0) {
            this._componentsMarkedForDeletion.get(this._deletionLevel - 1).remove(id);
        }
        return removedComponent;
    }

    @Override
    public void markForDeletion(UIComponent component) {
        this.increaseComponentLevelMarkedForDeletion();
        String id = (String)component.getAttributes().get("org.apache.myfaces.view.facelets.MARK_ID");
        id = id == null ? VIEWROOT_FACELET_ID : id;
        this.markComponentForDeletion(id, component);
        Map facets = component.getFacets();
        if (!facets.isEmpty()) {
            for (UIComponent fc : facets.values()) {
                id = (String)fc.getAttributes().get("org.apache.myfaces.view.facelets.MARK_ID");
                if (id != null) {
                    this.markComponentForDeletion(id, fc);
                    continue;
                }
                if (!Boolean.TRUE.equals(fc.getAttributes().get("org.apache.myfaces.facet.createdUIPanel"))) continue;
                for (UIComponent child : fc.getChildren()) {
                    id = (String)child.getAttributes().get("org.apache.myfaces.view.facelets.MARK_ID");
                    if (id == null) continue;
                    this.markComponentForDeletion(id, child);
                }
            }
        }
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                id = (String)child.getAttributes().get("org.apache.myfaces.view.facelets.MARK_ID");
                if (id == null) continue;
                this.markComponentForDeletion(id, child);
            }
        }
    }

    @Override
    public void finalizeForDeletion(UIComponent component) {
        Map facets;
        String id = (String)component.getAttributes().get("org.apache.myfaces.view.facelets.MARK_ID");
        id = id == null ? VIEWROOT_FACELET_ID : id;
        this.removeComponentForDeletion(id);
        if (component.getChildCount() > 0) {
            Iterator iter = component.getChildren().iterator();
            while (iter.hasNext()) {
                UIComponent child = (UIComponent)iter.next();
                id = (String)child.getAttributes().get("org.apache.myfaces.view.facelets.MARK_ID");
                if (id == null || this.removeComponentForDeletion(id) == null) continue;
                iter.remove();
            }
        }
        if (!(facets = component.getFacets()).isEmpty()) {
            Iterator itr = facets.values().iterator();
            while (itr.hasNext()) {
                UIComponent fc = (UIComponent)itr.next();
                id = (String)fc.getAttributes().get("org.apache.myfaces.view.facelets.MARK_ID");
                if (id != null && this.removeComponentForDeletion(id) != null) {
                    itr.remove();
                    continue;
                }
                if (id != null || !Boolean.TRUE.equals(fc.getAttributes().get("org.apache.myfaces.facet.createdUIPanel"))) continue;
                Iterator fciter = fc.getChildren().iterator();
                while (fciter.hasNext()) {
                    UIComponent child = (UIComponent)fciter.next();
                    id = (String)child.getAttributes().get("org.apache.myfaces.view.facelets.MARK_ID");
                    if (id == null || this.removeComponentForDeletion(id) == null) continue;
                    fciter.remove();
                }
                if (fc.getChildCount() != 0) continue;
                itr.remove();
            }
        }
        this.decreaseComponentLevelMarkedForDeletion();
    }
}

