/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.date;

import java.io.Serializable;
import java.sql.Date;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.component.AlignProperty;
import org.apache.myfaces.component.ForceIdAware;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.util.HtmlComponentUtils;
import org.apache.myfaces.custom.calendar.DateBusinessConverter;
import org.apache.myfaces.custom.calendar.DefaultDateBusinessConverter;

public abstract class AbstractHtmlInputDate
extends HtmlInputText
implements UserRoleAware,
ForceIdAware,
AlignProperty {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlInputDate";
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.Date";

    public String getClientId(FacesContext context) {
        String clientId = HtmlComponentUtils.getClientId((UIComponent)this, this.getRenderer(context), context);
        if (clientId == null) {
            clientId = super.getClientId(context);
        }
        return clientId;
    }

    public boolean isRendered() {
        if (!UserRoleUtils.isVisibleOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public UserData getUserData(Locale currentLocale) {
        return new UserData(this.getDateBusinessConverter(this).getDateValue(this.getFacesContext(), (UIComponent)this, this.getValue()), currentLocale, this.getTimeZone(), this.isAmpm(), this.getType());
    }

    private DateBusinessConverter getDateBusinessConverter(AbstractHtmlInputDate component) {
        DateBusinessConverter dateBusinessConverter = component.getDateBusinessConverter();
        if (dateBusinessConverter == null) {
            dateBusinessConverter = new DefaultDateBusinessConverter();
        }
        return dateBusinessConverter;
    }

    public abstract DateBusinessConverter getDateBusinessConverter();

    public abstract void setDateBusinessConverter(DateBusinessConverter var1);

    public abstract String getTimeZone();

    public abstract String getType();

    public abstract boolean isAmpm();

    public abstract boolean isPopupCalendar();

    public abstract String getEmptyMonthSelection();

    public abstract String getEmptyAmpmSelection();

    public abstract boolean isReadonly();

    public abstract boolean isDisabled();

    public Converter getConverter() {
        return super.getConverter();
    }

    public static class UserData
    implements Serializable {
        private static final long serialVersionUID = -6507279524833267707L;
        private String day;
        private String month;
        private String year;
        private String hours;
        private String minutes;
        private String seconds;
        private TimeZone timeZone = null;
        private String ampm;
        private boolean uses_ampm;
        private String type;

        public UserData(java.util.Date date, Locale currentLocale, String _timeZone, boolean uses_ampm, String type) {
            this.uses_ampm = uses_ampm;
            this.type = type;
            Calendar calendar = Calendar.getInstance(currentLocale);
            if (_timeZone != null) {
                this.timeZone = TimeZone.getTimeZone(_timeZone);
                calendar.setTimeZone(this.timeZone);
            }
            if (date == null) {
                return;
            }
            calendar.setTime(date);
            this.day = Integer.toString(calendar.get(5));
            this.month = Integer.toString(calendar.get(2) + 1);
            this.year = Integer.toString(calendar.get(1));
            if (uses_ampm) {
                int int_hours = calendar.get(10);
                if (int_hours == 0) {
                    int_hours = 12;
                }
                this.hours = Integer.toString(int_hours);
                this.ampm = Integer.toString(calendar.get(9));
            } else {
                this.hours = Integer.toString(calendar.get(11));
            }
            this.minutes = Integer.toString(calendar.get(12));
            this.seconds = Integer.toString(calendar.get(13));
        }

        public java.util.Date parse() throws ParseException {
            java.util.Date retDate = null;
            Calendar tempCalendar = Calendar.getInstance();
            tempCalendar.setLenient(Boolean.FALSE);
            if (this.timeZone != null) {
                tempCalendar.setTimeZone(this.timeZone);
            }
            try {
                if (!this.isSubmitValid(this.uses_ampm, this.type)) {
                    return null;
                }
                if (!this.type.equals("time") && !this.type.equals("short_time")) {
                    tempCalendar.set(5, Integer.parseInt(this.day));
                    tempCalendar.set(2, Integer.parseInt(this.month) - 1);
                    tempCalendar.set(1, Integer.parseInt(this.year));
                    if (this.type.equals("date")) {
                        tempCalendar.set(11, 0);
                        tempCalendar.set(12, 0);
                        tempCalendar.set(13, 0);
                        tempCalendar.set(14, 0);
                        return new Date(tempCalendar.getTimeInMillis());
                    }
                }
                if (!this.type.equals("date")) {
                    if (this.uses_ampm) {
                        int int_hours = Integer.parseInt(this.hours);
                        if (int_hours == 12) {
                            int_hours = 0;
                        }
                        tempCalendar.set(10, int_hours);
                        tempCalendar.set(9, Integer.parseInt(this.ampm));
                    } else {
                        tempCalendar.set(11, Integer.parseInt(this.hours));
                    }
                    tempCalendar.set(12, Integer.parseInt(this.minutes));
                    if (this.seconds != null & (this.type.equals("full") || this.type.equals("time") || this.type.equals("short_time"))) {
                        tempCalendar.set(13, Integer.parseInt(this.seconds));
                    } else {
                        tempCalendar.set(13, 0);
                    }
                }
                tempCalendar.set(14, 0);
                retDate = tempCalendar.getTime();
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage(), 0);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(e.getMessage(), 0);
            }
            return retDate;
        }

        private String formatedInt(String toFormat) {
            if (toFormat == null) {
                return null;
            }
            int i = -1;
            try {
                i = Integer.parseInt(toFormat);
            }
            catch (NumberFormatException nfe) {
                return toFormat;
            }
            if (i >= 0 && i < 10) {
                return "0" + i;
            }
            return Integer.toString(i);
        }

        private boolean isDateSubmitted(boolean usesAmpm, String type) {
            boolean isDateSubmitted;
            boolean bl = isDateSubmitted = !StringUtils.isEmpty((String)this.getDay()) || this.getMonth() != null && !this.getMonth().equals("-1") || !StringUtils.isEmpty((String)this.getYear());
            if (usesAmpm) {
                isDateSubmitted = isDateSubmitted || this.isAmpmSubmitted();
            }
            return isDateSubmitted;
        }

        private boolean isTimeSubmitted(boolean usesAmpm, String type) {
            boolean isTimeSubmitted;
            boolean bl = isTimeSubmitted = !StringUtils.isEmpty((String)this.getHours()) || !StringUtils.isEmpty((String)this.getMinutes());
            if (type.equals("time") || type.equals("full")) {
                boolean bl2 = isTimeSubmitted = isTimeSubmitted || !StringUtils.isEmpty((String)this.getSeconds());
            }
            if (usesAmpm) {
                isTimeSubmitted = isTimeSubmitted || this.isAmpmSubmitted();
            }
            return isTimeSubmitted;
        }

        private boolean isSubmitValid(boolean usesAmpm, String type) {
            if (type.equals("date")) {
                return this.isDateSubmitted(usesAmpm, type);
            }
            if (type.equals("time") || type.equals("short_time")) {
                return this.isTimeSubmitted(usesAmpm, type);
            }
            if (type.equals("full") || type.equals("both")) {
                return this.isDateSubmitted(usesAmpm, type) || this.isTimeSubmitted(usesAmpm, type);
            }
            return false;
        }

        private boolean isAmpmSubmitted() {
            if (this.getAmpm() == null) {
                return false;
            }
            return !this.getAmpm().equals("-1");
        }

        public String getDay() {
            return this.formatedInt(this.day);
        }

        public void setDay(String day) {
            this.day = day;
        }

        public String getMonth() {
            return this.month;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public String getYear() {
            return this.year;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public String getHours() {
            return this.formatedInt(this.hours);
        }

        public void setHours(String hours) {
            this.hours = hours;
        }

        public String getMinutes() {
            return this.formatedInt(this.minutes);
        }

        public void setMinutes(String minutes) {
            this.minutes = minutes;
        }

        public String getSeconds() {
            return this.formatedInt(this.seconds);
        }

        public void setSeconds(String seconds) {
            this.seconds = seconds;
        }

        public String getAmpm() {
            return this.ampm;
        }

        public void setAmpm(String ampm) {
            this.ampm = ampm;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

