/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.fileupload;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.fileupload.HtmlInputFileUpload;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.apache.myfaces.custom.fileupload.UploadedFileDefaultFileImpl;
import org.apache.myfaces.custom.fileupload.UploadedFileDefaultImplBase;
import org.apache.myfaces.custom.fileupload.UploadedFileDefaultMemoryImpl;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.webapp.filter.MultipartRequestWrapper;

public class HtmlFileUploadRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlFileUploadRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeEnd(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"file", null);
        String clientId = uiComponent.getClientId(facesContext);
        if (behaviors != null && !behaviors.isEmpty()) {
            writer.writeAttribute("id", (Object)clientId, null);
        } else {
            this.renderId(facesContext, uiComponent);
        }
        writer.writeAttribute("name", (Object)clientId, null);
        UploadedFile value = (UploadedFile)((HtmlInputFileUpload)uiComponent).getValue();
        if (value != null && value.getName() != null) {
            writer.writeAttribute("value", (Object)value.getName(), null);
        }
        if (behaviors != null && !behaviors.isEmpty()) {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_FILE_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, uiComponent, behaviors);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_FILE_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.endElement("input");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return true;
        }
        if (uiComponent instanceof HtmlInputFileUpload) {
            return ((HtmlInputFileUpload)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    private void setSubmittedValueForImplementation(FacesContext facesContext, UIComponent uiComponent, FileItem fileItem) {
        try {
            String implementation = ((HtmlInputFileUpload)uiComponent).getStorage();
            if (implementation == null || implementation.length() == 0) {
                implementation = "default";
            }
            UploadedFileDefaultImplBase upFile = "memory".equals(implementation) ? new UploadedFileDefaultMemoryImpl(fileItem) : ("default".equals(implementation) ? (fileItem.isInMemory() ? new UploadedFileDefaultMemoryImpl(fileItem) : new UploadedFileDefaultFileImpl(fileItem)) : new UploadedFileDefaultFileImpl(fileItem));
            ((HtmlInputFileUpload)uiComponent).setSubmittedValue(upFile);
            ((HtmlInputFileUpload)uiComponent).setValid(true);
        }
        catch (IOException ioe) {
            throw new FacesException("Exception while processing file upload for file-input : " + uiComponent.getClientId(facesContext), (Throwable)ioe);
        }
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        super.decode(facesContext, uiComponent);
        HtmlRendererUtils.decodeClientBehaviors(facesContext, uiComponent);
        Object request = facesContext.getExternalContext().getRequest();
        if (!(request instanceof ServletRequest)) {
            ExternalContext externalContext = facesContext.getExternalContext();
            Map fileItems = (Map)externalContext.getRequestMap().get("org.apache.myfaces.uploadedFiles");
            FileItem fileItem = null;
            if (fileItems != null) {
                String paramName = uiComponent.getClientId(facesContext);
                fileItem = (FileItem)fileItems.get(paramName);
            }
            if (fileItem != null) {
                this.setSubmittedValueForImplementation(facesContext, uiComponent, fileItem);
            }
            return;
        }
        if (facesContext.getExternalContext().getRequest() instanceof ServletRequest) {
            String paramName;
            MultipartRequestWrapper mpReq;
            FileItem fileItem;
            ServletRequest multipartRequest = (ServletRequest)facesContext.getExternalContext().getRequest();
            while (multipartRequest != null && !(multipartRequest instanceof MultipartRequestWrapper)) {
                if (multipartRequest instanceof HttpServletRequestWrapper) {
                    multipartRequest = ((HttpServletRequestWrapper)multipartRequest).getRequest();
                    continue;
                }
                multipartRequest = null;
            }
            if (multipartRequest != null && (fileItem = (mpReq = (MultipartRequestWrapper)multipartRequest).getFileItem(paramName = uiComponent.getClientId(facesContext))) != null) {
                this.setSubmittedValueForImplementation(facesContext, uiComponent, fileItem);
            }
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        UploadedFile file;
        if (submittedValue instanceof UploadedFile && (file = (UploadedFile)submittedValue).getSize() > 0L && file.getName() != null && file.getName().length() > 0) {
            return file;
        }
        return null;
    }
}

