/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.Resource;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.tree.HtmlTree;
import org.apache.myfaces.custom.tree.HtmlTreeColumn;
import org.apache.myfaces.custom.tree.HtmlTreeImageCommandLink;
import org.apache.myfaces.custom.tree.HtmlTreeNode;
import org.apache.myfaces.custom.tree.IconProvider;
import org.apache.myfaces.custom.tree.TreeNode;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlTableRendererBase;
import org.apache.myfaces.shared_tomahawk.util.ArrayUtils;
import org.apache.myfaces.shared_tomahawk.util.StringUtils;

public class HtmlTreeRenderer
extends HtmlTableRendererBase {
    private static final String DEFAULT_IMAGE_LIBRARY = "oam.custom.tree.images";
    private static final String DEFAULT_IMAGE_ICON_LINE = "images/line.gif";
    private static final String DEFAULT_IMAGE_ICON_NOLINE = "images/noline.gif";
    private static final String DEFAULT_IMAGE_ICON_CHILD_FIRST = "images/line_first.gif";
    private static final String DEFAULT_IMAGE_ICON_CHILD_MIDDLE = "images/line_middle.gif";
    private static final String DEFAULT_IMAGE_ICON_CHILD_LAST = "images/line_last.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_OPEN = "images/node_open.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_OPEN_FIRST = "images/node_open_first.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_OPEN_MIDDLE = "images/node_open_middle.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_OPEN_LAST = "images/node_open_last.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_CLOSE = "images/node_close.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_CLOSE_FIRST = "images/node_close_first.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_CLOSE_MIDDLE = "images/node_close_middle.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_CLOSE_LAST = "images/node_close_last.gif";
    private static final String DEFAULT_RESOURCE_ICON_LINE = "line.gif";
    private static final String DEFAULT_RESOURCE_ICON_NOLINE = "noline.gif";
    private static final String DEFAULT_RESOURCE_ICON_CHILD_FIRST = "line_first.gif";
    private static final String DEFAULT_RESOURCE_ICON_CHILD_MIDDLE = "line_middle.gif";
    private static final String DEFAULT_RESOURCE_ICON_CHILD_LAST = "line_last.gif";
    private static final String DEFAULT_RESOURCE_ICON_NODE_OPEN = "node_open.gif";
    private static final String DEFAULT_RESOURCE_ICON_NODE_OPEN_FIRST = "node_open_first.gif";
    private static final String DEFAULT_RESOURCE_ICON_NODE_OPEN_MIDDLE = "node_open_middle.gif";
    private static final String DEFAULT_RESOURCE_ICON_NODE_OPEN_LAST = "node_open_last.gif";
    private static final String DEFAULT_RESOURCE_ICON_NODE_CLOSE = "node_close.gif";
    private static final String DEFAULT_RESOURCE_ICON_NODE_CLOSE_FIRST = "node_close_first.gif";
    private static final String DEFAULT_RESOURCE_ICON_NODE_CLOSE_MIDDLE = "node_close_middle.gif";
    private static final String DEFAULT_RESOURCE_ICON_NODE_CLOSE_LAST = "node_close_last.gif";
    private static final Integer ZERO = new Integer(0);
    private static final String DEFAULT_IMAGE_ICON_FOLDER = "images/folder.gif";
    private static final String DEFAULT_RESOURCE_ICON_FOLDER = "folder.gif";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, HtmlTree.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlTree tree = (HtmlTree)component;
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("table", component);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)tree, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        writer.writeAttribute("border", (Object)ZERO, null);
        writer.writeAttribute("cellspacing", (Object)ZERO, null);
        writer.writeAttribute("cellpadding", (Object)ZERO, null);
        int maxLevel = tree.getRootNode().getMaxChildLevel();
        ArrayList<HtmlTreeNode> childNodes = new ArrayList<HtmlTreeNode>(1);
        childNodes.add(tree.getRootNode());
        this.renderFacet(facesContext, writer, component, true, maxLevel);
        this.renderChildren(facesContext, writer, tree, childNodes, maxLevel, tree.getIconProvider(), component);
        this.renderFacet(facesContext, writer, component, false, maxLevel);
        writer.endElement("table");
    }

    protected void renderFacet(FacesContext facesContext, ResponseWriter writer, UIComponent component, boolean header, int maxLevel) throws IOException {
        UIComponent facet;
        int colspan = 0;
        boolean hasColumnFacet = false;
        for (UIComponent uiComponent : component.getChildren()) {
            if (uiComponent.getFamily().equals("javax.faces.Column") && ((UIColumn)uiComponent).isRendered()) {
                ++colspan;
                if (hasColumnFacet) continue;
                hasColumnFacet = header ? ((UIColumn)uiComponent).getHeader() != null : ((UIColumn)uiComponent).getFooter() != null;
                continue;
            }
            if (!uiComponent.getFamily().equals("org.apache.myfaces.HtmlTreeColumn") || !((HtmlTreeColumn)uiComponent).isRendered()) continue;
            colspan += maxLevel + 3;
            if (hasColumnFacet) continue;
            hasColumnFacet = header ? ((UIColumn)uiComponent).getHeader() != null : ((UIColumn)uiComponent).getFooter() != null;
        }
        UIComponent uIComponent = facet = header ? (UIComponent)component.getFacets().get("header") : (UIComponent)component.getFacets().get("footer");
        if (facet != null || hasColumnFacet) {
            String elemName = header ? "thead" : "tfoot";
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement(elemName, component);
            if (header) {
                String headerStyleClass = HtmlTreeRenderer.getHeaderClass(component);
                if (facet != null) {
                    this.renderTableHeaderRow(facesContext, writer, component, facet, headerStyleClass, colspan);
                }
                if (hasColumnFacet) {
                    this.renderColumnHeaderRow(facesContext, writer, component, headerStyleClass, maxLevel);
                }
            } else {
                String footerStyleClass = HtmlTreeRenderer.getFooterClass(component);
                if (hasColumnFacet) {
                    this.renderColumnFooterRow(facesContext, writer, component, footerStyleClass, maxLevel);
                }
                if (facet != null) {
                    this.renderTableFooterRow(facesContext, writer, component, facet, footerStyleClass, colspan);
                }
            }
            writer.endElement(elemName);
        }
    }

    protected void renderColumnHeaderRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String headerStyleClass, int maxLevel) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, component, headerStyleClass, true, maxLevel);
    }

    protected void renderColumnFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String footerStyleClass, int maxLevel) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, component, footerStyleClass, false, maxLevel);
    }

    private void renderColumnHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String styleClass, boolean header, int maxLevel) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", component);
        for (UIComponent uiComponent : component.getChildren()) {
            if (uiComponent.getFamily().equals("javax.faces.Column") && ((UIColumn)uiComponent).isRendered()) {
                if (header) {
                    this.renderColumnHeaderCell(facesContext, writer, (UIColumn)uiComponent, styleClass, 0);
                    continue;
                }
                this.renderColumnFooterCell(facesContext, writer, (UIColumn)uiComponent, styleClass, 0);
                continue;
            }
            if (!uiComponent.getFamily().equals("org.apache.myfaces.HtmlTreeColumn") || !((HtmlTreeColumn)uiComponent).isRendered()) continue;
            if (header) {
                this.renderColumnHeaderCell(facesContext, writer, (UIColumn)uiComponent, styleClass, maxLevel + 3);
                continue;
            }
            this.renderColumnFooterCell(facesContext, writer, (UIColumn)uiComponent, styleClass, maxLevel + 3);
        }
        writer.endElement("tr");
    }

    protected void renderChildren(FacesContext facesContext, ResponseWriter writer, HtmlTree tree, List children, int maxLevel, IconProvider iconProvider, UIComponent component) throws IOException {
        this.renderChildren(facesContext, writer, tree, children, maxLevel, iconProvider, 0, component);
    }

    protected void renderChildren(FacesContext facesContext, ResponseWriter writer, HtmlTree tree, List children, int maxLevel, IconProvider iconProvider, int rowClassIndex, UIComponent component) throws IOException {
        String rowClasses = tree.getRowClasses();
        String columnClasses = tree.getColumnClasses();
        String[] rowClassesArray = rowClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(rowClasses, ','));
        int rowClassesCount = rowClassesArray.length;
        String[] columnClassesArray = columnClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(columnClasses, ','));
        int columnClassesCount = columnClassesArray.length;
        int columnClassIndex = 0;
        for (HtmlTreeNode child : children) {
            List componentChildren;
            if (!child.isRendered()) continue;
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("tr", component);
            if (rowClassIndex < rowClassesCount) {
                writer.writeAttribute("class", (Object)rowClassesArray[rowClassIndex], null);
            }
            if (rowClassesCount > 0) {
                ++rowClassIndex;
                rowClassIndex %= rowClassesCount;
            }
            if (null != tree.getVar()) {
                facesContext.getExternalContext().getSessionMap().put(tree.getVar(), ((TreeNode)child.getUserObject()).getUserObject());
            }
            if (null != (componentChildren = tree.getChildren()) && componentChildren.size() > 0) {
                int size = tree.getChildCount();
                for (int j = 0; j < size; ++j) {
                    UIComponent componentChild = (UIComponent)componentChildren.get(j);
                    if (componentChild.getFamily().equals("javax.faces.Column") && ((UIColumn)componentChild).isRendered()) {
                        writer.startElement("td", (UIComponent)tree);
                        if (columnClassIndex < columnClassesCount) {
                            writer.writeAttribute("class", (Object)columnClassesArray[columnClassIndex], null);
                        }
                        if (columnClassesCount > 0) {
                            ++columnClassIndex;
                            columnClassIndex %= columnClassesCount;
                        }
                        RendererUtils.renderChild(facesContext, componentChild);
                        writer.endElement("td");
                        continue;
                    }
                    if (!componentChild.getFamily().equals("org.apache.myfaces.HtmlTreeColumn") || !((HtmlTreeColumn)componentChild).isRendered()) continue;
                    this.renderTreeColumnChild(facesContext, writer, componentChild, tree, child, maxLevel, iconProvider);
                }
            } else {
                this.renderTreeColumnChild(facesContext, writer, null, tree, child, maxLevel, iconProvider);
            }
            writer.endElement("tr");
            if (child.getChildCount() <= 0) continue;
            this.renderChildren(facesContext, writer, tree, child.getChildren(), maxLevel, iconProvider, rowClassIndex, component);
            if (rowClassesCount <= 0) continue;
            rowClassIndex += child.getChildCount() % rowClassesCount;
            rowClassIndex %= rowClassesCount;
        }
    }

    protected void renderTreeColumnChild(FacesContext facesContext, ResponseWriter writer, UIComponent component, HtmlTree tree, HtmlTreeNode child, int maxLevel, IconProvider iconProvider) throws IOException {
        Resource resource;
        String iconClass = tree.getIconClass();
        int[] layout = child.getLayout();
        for (int i = 0; i < layout.length - 1; ++i) {
            int state = layout[i];
            writer.startElement("td", (UIComponent)child);
            String url = this.getLayoutImage(facesContext, tree, state);
            if (url != null && url.length() > 0) {
                this.writeImageElement(url, facesContext, writer, child);
            } else {
                String resourceName = this.getDefaultLayoutResourceName(facesContext, tree, state);
                Resource resource2 = facesContext.getApplication().getResourceHandler().createResource(resourceName, DEFAULT_IMAGE_LIBRARY);
                this.writeImageElementWithoutEncodeResourceURL(resource2.getRequestPath(), facesContext, writer, child);
            }
            writer.endElement("td");
        }
        writer.startElement("td", (UIComponent)tree);
        int state = layout[layout.length - 1];
        String url = this.getLayoutImage(facesContext, tree, state);
        if (state == 20 || state == 21 || state == 22) {
            if (url != null && url.length() > 0) {
                this.writeImageElement(url, facesContext, writer, child);
            } else {
                String resourceName = this.getDefaultLayoutResourceName(facesContext, tree, state);
                resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, DEFAULT_IMAGE_LIBRARY);
                this.writeImageElementWithoutEncodeResourceURL(resource.getRequestPath(), facesContext, writer, child);
            }
        } else {
            HtmlTreeImageCommandLink expandCollapse = child.getExpandCollapseCommand(facesContext);
            String url1 = this.getLayoutImage(facesContext, tree, layout[layout.length - 1]);
            if (url1 != null && url1.length() > 0) {
                expandCollapse.setImage(url1);
            } else {
                String resourceName = this.getDefaultLayoutResourceName(facesContext, tree, layout[layout.length - 1]);
                expandCollapse.getAttributes().put("library", DEFAULT_IMAGE_LIBRARY);
                expandCollapse.getAttributes().put("name", resourceName);
            }
            expandCollapse.encodeBegin(facesContext);
            expandCollapse.encodeEnd(facesContext);
        }
        writer.endElement("td");
        int labelColSpan = maxLevel - child.getLevel() + 1;
        url = iconProvider != null ? iconProvider.getIconUrl(child.getUserObject(), child.getChildCount(), child.isLeaf(facesContext)) : null;
        if (url != null && url.length() > 0) {
            writer.startElement("td", (UIComponent)tree);
            if (iconClass != null) {
                writer.writeAttribute("class", (Object)iconClass, null);
            }
            this.writeImageElement(url, facesContext, writer, child);
            writer.endElement("td");
        } else if (!child.isLeaf(facesContext) && iconProvider == null) {
            resource = facesContext.getApplication().getResourceHandler().createResource(DEFAULT_RESOURCE_ICON_FOLDER, DEFAULT_IMAGE_LIBRARY);
            writer.startElement("td", (UIComponent)tree);
            if (iconClass != null) {
                writer.writeAttribute("class", (Object)iconClass, null);
            }
            this.writeImageElementWithoutEncodeResourceURL(resource.getRequestPath(), facesContext, writer, child);
            writer.endElement("td");
        } else {
            ++labelColSpan;
        }
        writer.startElement("td", (UIComponent)tree);
        writer.writeAttribute("colspan", (Object)new Integer(labelColSpan), null);
        if (child.isSelected() && tree.getSelectedNodeClass() != null) {
            writer.writeAttribute("class", (Object)tree.getSelectedNodeClass(), null);
        } else if (!child.isSelected() && tree.getNodeClass() != null) {
            writer.writeAttribute("class", (Object)tree.getNodeClass(), null);
        }
        List componentChildren = null;
        if (null != component) {
            componentChildren = component.getChildren();
        }
        if (null != componentChildren && componentChildren.size() > 0) {
            for (int k = 0; k < componentChildren.size(); ++k) {
                UIComponent componentChild = (UIComponent)componentChildren.get(k);
                RendererUtils.renderChild(facesContext, componentChild);
            }
        } else {
            child.encodeBegin(facesContext);
            child.encodeEnd(facesContext);
        }
        writer.endElement("td");
    }

    private void writeImageElement(String url, FacesContext facesContext, ResponseWriter writer, HtmlTreeNode child) throws IOException {
        writer.startElement("img", (UIComponent)child);
        String src = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, url);
        writer.writeAttribute("src", (Object)src, null);
        writer.writeAttribute("border", (Object)ZERO, null);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)child, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
        writer.endElement("img");
    }

    private void writeImageElementWithoutEncodeResourceURL(String url, FacesContext facesContext, ResponseWriter writer, HtmlTreeNode child) throws IOException {
        writer.startElement("img", (UIComponent)child);
        writer.writeAttribute("src", (Object)url, null);
        writer.writeAttribute("border", (Object)ZERO, null);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)child, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
        writer.endElement("img");
    }

    protected String getLayoutImage(FacesContext context, HtmlTree tree, int state) {
        switch (state) {
            case 0: {
                return this.getImageUrl(context, tree.getIconNodeOpenMiddle(), DEFAULT_IMAGE_ICON_NODE_OPEN_MIDDLE);
            }
            case 1: {
                return this.getImageUrl(context, tree.getIconNodeOpenFirst(), DEFAULT_IMAGE_ICON_NODE_OPEN_FIRST);
            }
            case 2: {
                return this.getImageUrl(context, tree.getIconNodeOpenLast(), DEFAULT_IMAGE_ICON_NODE_OPEN_LAST);
            }
            case 3: {
                return this.getImageUrl(context, tree.getIconNodeOpen(), DEFAULT_IMAGE_ICON_NODE_OPEN);
            }
            case 10: {
                return this.getImageUrl(context, tree.getIconNodeCloseMiddle(), DEFAULT_IMAGE_ICON_NODE_CLOSE_MIDDLE);
            }
            case 11: {
                return this.getImageUrl(context, tree.getIconNodeCloseFirst(), DEFAULT_IMAGE_ICON_NODE_CLOSE_FIRST);
            }
            case 12: {
                return this.getImageUrl(context, tree.getIconNodeCloseLast(), DEFAULT_IMAGE_ICON_NODE_CLOSE_LAST);
            }
            case 13: {
                return this.getImageUrl(context, tree.getIconNodeClose(), DEFAULT_IMAGE_ICON_NODE_CLOSE);
            }
            case 20: {
                return this.getImageUrl(context, tree.getIconChildMiddle(), DEFAULT_IMAGE_ICON_CHILD_MIDDLE);
            }
            case 21: {
                return this.getImageUrl(context, tree.getIconChildFirst(), DEFAULT_IMAGE_ICON_CHILD_FIRST);
            }
            case 22: {
                return this.getImageUrl(context, tree.getIconChildLast(), DEFAULT_IMAGE_ICON_CHILD_LAST);
            }
            case 30: {
                return this.getImageUrl(context, tree.getIconLine(), DEFAULT_IMAGE_ICON_LINE);
            }
            case 40: {
                return this.getImageUrl(context, tree.getIconNoline(), DEFAULT_IMAGE_ICON_NOLINE);
            }
        }
        return this.getImageUrl(context, tree.getIconNoline(), DEFAULT_IMAGE_ICON_NOLINE);
    }

    protected String getDefaultLayoutResourceName(FacesContext context, HtmlTree tree, int state) {
        switch (state) {
            case 0: {
                return DEFAULT_RESOURCE_ICON_NODE_OPEN_MIDDLE;
            }
            case 1: {
                return DEFAULT_RESOURCE_ICON_NODE_OPEN_FIRST;
            }
            case 2: {
                return DEFAULT_RESOURCE_ICON_NODE_OPEN_LAST;
            }
            case 3: {
                return DEFAULT_RESOURCE_ICON_NODE_OPEN;
            }
            case 10: {
                return DEFAULT_RESOURCE_ICON_NODE_CLOSE_MIDDLE;
            }
            case 11: {
                return DEFAULT_RESOURCE_ICON_NODE_CLOSE_FIRST;
            }
            case 12: {
                return DEFAULT_RESOURCE_ICON_NODE_CLOSE_LAST;
            }
            case 13: {
                return DEFAULT_RESOURCE_ICON_NODE_CLOSE;
            }
            case 20: {
                return DEFAULT_RESOURCE_ICON_CHILD_MIDDLE;
            }
            case 21: {
                return DEFAULT_RESOURCE_ICON_CHILD_FIRST;
            }
            case 22: {
                return DEFAULT_RESOURCE_ICON_CHILD_LAST;
            }
            case 30: {
                return DEFAULT_RESOURCE_ICON_LINE;
            }
            case 40: {
                return DEFAULT_RESOURCE_ICON_NOLINE;
            }
        }
        return DEFAULT_RESOURCE_ICON_NOLINE;
    }

    protected String getImageUrl(FacesContext context, String userValue, String resourceValue) {
        if (userValue != null) {
            AddResource addResource = AddResourceFactory.getInstance(context);
            return addResource.getResourceUri(context, userValue, false);
        }
        return null;
    }
}

