/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.component.html.ext.HtmlPanelGroup;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlGroupRendererBase;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.ResourceUtils;

public class HtmlGroupRenderer
extends HtmlGroupRendererBase {
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean span = false;
        String element = this.getHtmlElement(component);
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)component).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(context, writer);
        }
        if (behaviors != null && !behaviors.isEmpty()) {
            span = true;
            writer.startElement(element, component);
            writer.writeAttribute("id", (Object)component.getClientId(context), null);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.UNIVERSAL_ATTRIBUTES);
            HtmlRendererUtils.renderBehaviorizedEventHandlers(context, writer, component, behaviors);
        } else if (component.getId() != null && !component.getId().startsWith("j_id")) {
            span = true;
            writer.startElement(element, component);
            HtmlRendererUtils.writeIdIfNecessary(writer, component, context);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
        } else {
            span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, component, element, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
        }
        RendererUtils.renderChildren(context, component);
        if (span) {
            writer.endElement(element);
        }
    }

    private String getHtmlElement(UIComponent component) {
        HtmlPanelGroup group;
        if (component instanceof HtmlPanelGroup && "block".equals((group = (HtmlPanelGroup)component).getLayout())) {
            return "div";
        }
        return "span";
    }
}

