/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.CustomScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.NoneScoped;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.SessionScoped;
import javax.faces.bean.ViewScoped;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.context.ExternalContext;
import javax.faces.convert.FacesConverter;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.NamedEvent;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.validator.FacesValidator;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.NamedEventManager;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.impl.digester.elements.FacesConfig;
import org.apache.myfaces.config.impl.digester.elements.ManagedProperty;
import org.apache.myfaces.spi.AnnotationProvider;
import org.apache.myfaces.spi.AnnotationProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfigurator {
    private static final Logger log = Logger.getLogger(AnnotationConfigurator.class.getName());
    private final ExternalContext _externalContext;
    private RenderKitFactory rkFactory = null;

    public AnnotationConfigurator(ExternalContext externalContext) {
        this._externalContext = externalContext;
    }

    public void configure(Application application, FacesConfigDispenser<FacesConfig> dispenser, boolean metadataComplete) throws FacesException {
        AnnotationProvider provider = AnnotationProviderFactory.getAnnotationProviderFactory(this._externalContext).createAnnotationProvider(this._externalContext);
        Map<Class<? extends Annotation>, Set<Class<?>>> map = provider.getAnnotatedClasses(this._externalContext);
        this.configureClasses(application, dispenser, map);
    }

    protected void configureClasses(Application application, FacesConfigDispenser<FacesConfig> dispenser, Map<Class<? extends Annotation>, Set<Class<?>>> map) {
        String renderKitId;
        Set<Class<?>> classes = map.get(FacesComponent.class);
        if (classes != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                FacesComponent comp = clazz.getAnnotation(FacesComponent.class);
                if (comp == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addComponent(" + comp.value() + "," + clazz.getName() + ")");
                }
                if (dispenser.getComponentClass(comp.value()) != null) continue;
                application.addComponent(comp.value(), clazz.getName());
            }
        }
        if ((classes = map.get(FacesConverter.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                FacesConverter conv = clazz.getAnnotation(FacesConverter.class);
                if (conv == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addConverter(" + conv.value() + "," + clazz.getName() + ")");
                }
                if (!Object.class.equals((Object)conv.forClass())) {
                    application.addConverter(conv.forClass(), clazz.getName());
                }
                if (dispenser.getConverterClassById(conv.value()) != null || conv.value() == null || "".equals(conv.value())) continue;
                application.addConverter(conv.value(), clazz.getName());
            }
        }
        if ((classes = map.get(FacesValidator.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                FacesValidator val = clazz.getAnnotation(FacesValidator.class);
                if (val == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addValidator(" + val.value() + "," + clazz.getName() + ")");
                }
                if (dispenser.getValidatorClass(val.value()) != null) continue;
                application.addValidator(val.value(), clazz.getName());
                if (!val.isDefault()) continue;
                application.addDefaultValidatorId(val.value());
            }
        }
        if ((classes = map.get(FacesRenderer.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                FacesRenderer rend = clazz.getAnnotation(FacesRenderer.class);
                if (rend == null) continue;
                renderKitId = rend.renderKitId();
                if (renderKitId == null) {
                    renderKitId = "HTML_BASIC";
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addRenderer(" + renderKitId + ", " + rend.componentFamily() + ", " + rend.rendererType() + ", " + clazz.getName() + ")");
                }
                try {
                    RenderKit rk = this.renderKitFactory().getRenderKit(null, renderKitId);
                    if (rk == null) {
                        if (log.isLoggable(Level.SEVERE)) {
                            log.severe("RenderKit " + renderKitId + " not found when adding @FacesRenderer annotation");
                        }
                        throw new FacesException("RenderKit " + renderKitId + " not found when adding @FacesRenderer annotation");
                    }
                    rk.addRenderer(rend.componentFamily(), rend.rendererType(), (Renderer)clazz.newInstance());
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
            }
        }
        if ((classes = map.get(ManagedBean.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                Field[] fields;
                ManagedBean bean = clazz.getAnnotation(ManagedBean.class);
                if (bean == null) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Class '" + clazz.getName() + "' has an @ManagedBean annotation");
                }
                RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
                org.apache.myfaces.config.impl.digester.elements.ManagedBean mbc = new org.apache.myfaces.config.impl.digester.elements.ManagedBean();
                String beanName = bean.name();
                if (beanName == null || beanName.equals("")) {
                    beanName = clazz.getName();
                    int index = beanName.lastIndexOf(".");
                    if (index != -1) {
                        beanName = beanName.substring(index + 1);
                    }
                    beanName = Character.toLowerCase(beanName.charAt(0)) + beanName.substring(1);
                }
                mbc.setName(beanName);
                mbc.setEager(Boolean.toString(bean.eager()));
                mbc.setBeanClass(clazz.getName());
                ApplicationScoped appScoped = clazz.getAnnotation(ApplicationScoped.class);
                if (appScoped != null) {
                    mbc.setScope("application");
                } else {
                    NoneScoped noneScoped = clazz.getAnnotation(NoneScoped.class);
                    if (noneScoped != null) {
                        mbc.setScope("none");
                    } else {
                        RequestScoped requestScoped = clazz.getAnnotation(RequestScoped.class);
                        if (requestScoped != null) {
                            mbc.setScope("request");
                        } else {
                            SessionScoped sessionScoped = clazz.getAnnotation(SessionScoped.class);
                            if (sessionScoped != null) {
                                mbc.setScope("session");
                            } else {
                                ViewScoped viewScoped = clazz.getAnnotation(ViewScoped.class);
                                if (viewScoped != null) {
                                    mbc.setScope("view");
                                } else {
                                    CustomScoped customScoped = clazz.getAnnotation(CustomScoped.class);
                                    if (customScoped != null) {
                                        mbc.setScope(customScoped.value());
                                    } else {
                                        mbc.setScope("request");
                                    }
                                }
                            }
                        }
                    }
                }
                for (Field field : fields = this.fields(clazz)) {
                    javax.faces.bean.ManagedProperty property;
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("  Scanning field '" + field.getName() + "'");
                    }
                    if ((property = field.getAnnotation(javax.faces.bean.ManagedProperty.class)) == null) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("  Field '" + field.getName() + "' has a @ManagedProperty annotation");
                    }
                    ManagedProperty mpc = new ManagedProperty();
                    String name = property.name();
                    if (name == null || "".equals(name)) {
                        name = field.getName();
                    }
                    mpc.setPropertyName(name);
                    mpc.setPropertyClass(field.getType().getName());
                    mpc.setValue(property.value());
                    mbc.addProperty(mpc);
                }
                runtimeConfig.addManagedBean(mbc.getManagedBeanName(), mbc);
            }
        }
        if ((classes = map.get(NamedEvent.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                NamedEvent namedEvent = clazz.getAnnotation(NamedEvent.class);
                if (namedEvent == null) continue;
                if (!ComponentSystemEvent.class.isAssignableFrom(clazz)) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.warning(clazz.getName() + " is annotated with @javax.faces.event.NamedEvent, but does " + "not extend javax.faces.event.ComponentSystemEvent");
                    }
                    return;
                }
                NamedEventManager.getInstance().addNamedEvent(namedEvent.shortName(), clazz);
            }
        }
        if ((classes = map.get(FacesBehavior.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                FacesBehavior facesBehavior = clazz.getAnnotation(FacesBehavior.class);
                if (facesBehavior == null) continue;
                if (!Behavior.class.isAssignableFrom(clazz) && log.isLoggable(Level.WARNING)) {
                    log.warning(clazz.getName() + " is annotated with @javax.faces.component.behavior.FacesBehavior, " + "but does not implement javax.faces.component.behavior.Behavior");
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addBehavior(" + facesBehavior.value() + ", " + clazz.getName() + ")");
                }
                application.addBehavior(facesBehavior.value(), clazz.getName());
            }
        }
        if ((classes = map.get(FacesBehaviorRenderer.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                FacesBehaviorRenderer facesBehaviorRenderer = clazz.getAnnotation(FacesBehaviorRenderer.class);
                if (facesBehaviorRenderer == null) continue;
                renderKitId = facesBehaviorRenderer.renderKitId();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addClientBehaviorRenderer(" + renderKitId + ", " + facesBehaviorRenderer.rendererType() + ", " + clazz.getName() + ")");
                }
                try {
                    RenderKit renderKit = this.renderKitFactory().getRenderKit(null, renderKitId);
                    ClientBehaviorRenderer clientBehaviorRenderer = (ClientBehaviorRenderer)clazz.newInstance();
                    renderKit.addClientBehaviorRenderer(facesBehaviorRenderer.rendererType(), clientBehaviorRenderer);
                }
                catch (Throwable e) {
                    throw new FacesException(e);
                }
            }
        }
    }

    private Field[] fields(Class<?> clazz) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return fields.values().toArray(new Field[fields.size()]);
    }

    private RenderKitFactory renderKitFactory() {
        if (this.rkFactory == null) {
            this.rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        }
        return this.rkFactory;
    }
}

