/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELResolver;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ProjectStage;
import javax.faces.application.ResourceHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyCustomScopeEvent;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.myfaces.application.ApplicationFactoryImpl;
import org.apache.myfaces.application.ApplicationImpl;
import org.apache.myfaces.application.BackwardsCompatibleNavigationHandlerWrapper;
import org.apache.myfaces.component.visit.VisitContextFactoryImpl;
import org.apache.myfaces.config.ConfigFilesXmlValidationUtils;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.ManagedBeanDestroyer;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.AnnotationConfigurator;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.config.element.Behavior;
import org.apache.myfaces.config.element.ClientBehaviorRenderer;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigDispenserImpl;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigUnmarshallerImpl;
import org.apache.myfaces.config.impl.digester.elements.ConfigOthersSlot;
import org.apache.myfaces.config.impl.digester.elements.FacesConfig;
import org.apache.myfaces.config.impl.digester.elements.FacesConfigNameSlot;
import org.apache.myfaces.config.impl.digester.elements.OrderSlot;
import org.apache.myfaces.config.impl.digester.elements.Ordering;
import org.apache.myfaces.config.impl.digester.elements.ResourceBundle;
import org.apache.myfaces.config.impl.digester.elements.SystemEventListener;
import org.apache.myfaces.config.util.CyclicDependencyException;
import org.apache.myfaces.config.util.DirectedAcyclicGraphVerifier;
import org.apache.myfaces.config.util.Vertex;
import org.apache.myfaces.context.ExceptionHandlerFactoryImpl;
import org.apache.myfaces.context.ExternalContextFactoryImpl;
import org.apache.myfaces.context.FacesContextFactoryImpl;
import org.apache.myfaces.context.PartialViewContextFactoryImpl;
import org.apache.myfaces.el.DefaultPropertyResolver;
import org.apache.myfaces.el.VariableResolverImpl;
import org.apache.myfaces.lifecycle.LifecycleFactoryImpl;
import org.apache.myfaces.renderkit.RenderKitFactoryImpl;
import org.apache.myfaces.renderkit.html.HtmlRenderKitImpl;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.shared_impl.util.LocaleUtils;
import org.apache.myfaces.shared_impl.util.serial.DefaultSerialFactory;
import org.apache.myfaces.shared_impl.util.serial.SerialFactory;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.spi.FacesConfigResourceProviderFactory;
import org.apache.myfaces.util.ContainerUtils;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.view.ViewDeclarationLanguageFactoryImpl;
import org.apache.myfaces.view.facelets.tag.jsf.TagHandlerDelegateFactoryImpl;
import org.apache.myfaces.view.facelets.tag.ui.DebugPhaseListener;
import org.apache.myfaces.webapp.ManagedBeanDestroyerListener;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigurator {
    private static final Logger log = Logger.getLogger(FacesConfigurator.class.getName());
    private static final String STANDARD_FACES_CONFIG_RESOURCE = "META-INF/standard-faces-config.xml";
    private static final String META_INF_SERVICES_RESOURCE_PREFIX = "META-INF/services/";
    private static final String DEFAULT_RENDER_KIT_CLASS = HtmlRenderKitImpl.class.getName();
    private static final String DEFAULT_APPLICATION_FACTORY = ApplicationFactoryImpl.class.getName();
    private static final String DEFAULT_EXTERNAL_CONTEXT_FACTORY = ExternalContextFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONTEXT_FACTORY = FacesContextFactoryImpl.class.getName();
    private static final String DEFAULT_LIFECYCLE_FACTORY = LifecycleFactoryImpl.class.getName();
    private static final String DEFAULT_RENDER_KIT_FACTORY = RenderKitFactoryImpl.class.getName();
    private static final String DEFAULT_PARTIAL_VIEW_CONTEXT_FACTORY = PartialViewContextFactoryImpl.class.getName();
    private static final String DEFAULT_VISIT_CONTEXT_FACTORY = VisitContextFactoryImpl.class.getName();
    private static final String DEFAULT_VIEW_DECLARATION_LANGUAGE_FACTORY = ViewDeclarationLanguageFactoryImpl.class.getName();
    private static final String DEFAULT_EXCEPTION_HANDLER_FACTORY = ExceptionHandlerFactoryImpl.class.getName();
    private static final String DEFAULT_TAG_HANDLER_DELEGATE_FACTORY = TagHandlerDelegateFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    private static final Set<String> FACTORY_NAMES = new HashSet<String>();
    private final ExternalContext _externalContext;
    private FacesConfigUnmarshaller<? extends FacesConfig> _unmarshaller;
    private FacesConfigDispenser<FacesConfig> _dispenser;
    private AnnotationConfigurator _annotationConfigurator;
    private RuntimeConfig _runtimeConfig;
    private static long lastUpdate;
    public static final String MYFACES_API_PACKAGE_NAME = "myfaces-api";
    public static final String MYFACES_IMPL_PACKAGE_NAME = "myfaces-impl";
    public static final String MYFACES_TOMAHAWK_PACKAGE_NAME = "tomahawk";
    public static final String MYFACES_TOMAHAWK12_PACKAGE_NAME = "tomahawk12";
    public static final String MYFACES_ORCHESTRA_PACKAGE_NAME = "myfaces-orchestra-core";
    public static final String MYFACES_ORCHESTRA12_PACKAGE_NAME = "myfaces-orchestra-core12";
    public static final String MYFACES_TRINIDAD_API_PACKAGE_NAME = "trinidad-api";
    public static final String MYFACES_TRINIDAD_IMPL_PACKAGE_NAME = "trinidad-impl";
    public static final String MYFACES_TOBAGO_PACKAGE_NAME = "tobago";
    public static final String MYFACES_TOMAHAWK_SANDBOX_PACKAGE_NAME = "tomahawk-sandbox";
    public static final String MYFACES_TOMAHAWK_SANDBOX12_PACKAGE_NAME = "tomahawk-sandbox12";
    public static final String MYFACES_TOMAHAWK_SANDBOX15_PACKAGE_NAME = "tomahawk-sandbox15";
    public static final String COMMONS_EL_PACKAGE_NAME = "commons-el";
    public static final String JSP_API_PACKAGE_NAME = "jsp-api";
    private static final String[] ARTIFACTS_IDS;
    public static final String REGEX_LIBRARY = "((jar)?(besjar)?(wsjar)?(zip)?)?:(file:.*/(.+)-(\\d+)(\\.(\\d+)(\\.(\\d+)(\\.(\\d+))?)?)?(-SNAPSHOT)?\\.jar)!/META-INF/MANIFEST.MF";
    private static final Pattern REGEX_LIBRARY_PATTERN;
    private static final int REGEX_LIBRARY_FILE_PATH = 6;
    private static final int REGEX_LIBRARY_ARTIFACT_ID = 7;
    private static final int REGEX_LIBRARY_MAJOR_VERSION = 8;
    private static final int REGEX_LIBRARY_MINOR_VERSION = 10;
    private static final int REGEX_LIBRARY_MAINTENANCE_VERSION = 12;
    private static final int REGEX_LIBRARY_EXTRA_VERSION = 14;
    private static final int REGEX_LIBRARY_SNAPSHOT_MARKER = 15;

    public FacesConfigurator(ExternalContext externalContext) {
        FACTORY_NAMES.add("javax.faces.application.ApplicationFactory");
        FACTORY_NAMES.add("javax.faces.context.ExceptionHandlerFactory");
        FACTORY_NAMES.add("javax.faces.context.ExternalContextFactory");
        FACTORY_NAMES.add("javax.faces.context.FacesContextFactory");
        FACTORY_NAMES.add("javax.faces.lifecycle.LifecycleFactory");
        FACTORY_NAMES.add("javax.faces.render.RenderKitFactory");
        FACTORY_NAMES.add("javax.faces.view.facelets.TagHandlerDelegateFactory");
        FACTORY_NAMES.add("javax.faces.context.PartialViewContextFactory");
        FACTORY_NAMES.add("javax.faces.component.visit.VisitContextFactory");
        FACTORY_NAMES.add("javax.faces.view.ViewDeclarationLanguageFactory");
        if (externalContext == null) {
            throw new IllegalArgumentException("external context must not be null");
        }
        this._externalContext = externalContext;
    }

    public void setUnmarshaller(FacesConfigUnmarshaller<? extends FacesConfig> unmarshaller) {
        this._unmarshaller = unmarshaller;
    }

    protected FacesConfigUnmarshaller<? extends FacesConfig> getUnmarshaller() {
        if (this._unmarshaller == null) {
            this._unmarshaller = new DigesterFacesConfigUnmarshallerImpl(this._externalContext);
        }
        return this._unmarshaller;
    }

    public void setDispenser(FacesConfigDispenser<FacesConfig> dispenser) {
        this._dispenser = dispenser;
    }

    protected FacesConfigDispenser<FacesConfig> getDispenser() {
        if (this._dispenser == null) {
            this._dispenser = new DigesterFacesConfigDispenserImpl();
        }
        return this._dispenser;
    }

    public void setAnnotationConfigurator(AnnotationConfigurator configurator) {
        this._annotationConfigurator = configurator;
    }

    protected AnnotationConfigurator getAnnotationConfigurator() {
        if (this._annotationConfigurator == null) {
            this._annotationConfigurator = new AnnotationConfigurator(this._externalContext);
        }
        return this._annotationConfigurator;
    }

    private long getResourceLastModified(String resource) {
        try {
            URL url = this._externalContext.getResource(resource);
            if (url != null) {
                return this.getResourceLastModified(url);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not read resource " + resource, e);
        }
        return 0L;
    }

    private long getResourceLastModified(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            String externalForm = url.toExternalForm();
            File file = new File(externalForm.substring(5));
            return file.lastModified();
        }
        return this.getResourceLastModified(url.openConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getResourceLastModified(URLConnection connection) throws IOException {
        long modified;
        if (connection instanceof JarURLConnection) {
            URL jarFileUrl = ((JarURLConnection)connection).getJarFileURL();
            URLConnection jarFileConnection = jarFileUrl.openConnection();
            try {
                modified = jarFileConnection.getLastModified();
            }
            finally {
                try {
                    jarFileConnection.getInputStream().close();
                }
                catch (Exception exception) {}
            }
        }
        modified = connection.getLastModified();
        return modified;
    }

    private long getLastModifiedTime() {
        long lastModified = 0L;
        long resModified = this.getResourceLastModified(DEFAULT_FACES_CONFIG);
        if (resModified > lastModified) {
            lastModified = resModified;
        }
        for (String systemId : this.getConfigFilesList()) {
            resModified = this.getResourceLastModified(systemId);
            if (resModified <= lastModified) continue;
            lastModified = resModified;
        }
        return lastModified;
    }

    public void update() {
        if (ContainerUtils.isRunningOnGoogleAppEngine(this._externalContext)) {
            return;
        }
        long refreshPeriod = MyfacesConfig.getCurrentInstance(this._externalContext).getConfigRefreshPeriod() * 1000L;
        if (refreshPeriod > 0L) {
            long ttl = lastUpdate + refreshPeriod;
            if (System.currentTimeMillis() > ttl && this.getLastModifiedTime() > ttl) {
                try {
                    this.purgeConfiguration();
                }
                catch (NoSuchMethodException e) {
                    log.severe("Configuration objects do not support clean-up. Update aborted");
                    lastUpdate = System.currentTimeMillis();
                    return;
                }
                catch (IllegalAccessException e) {
                    log.severe("Error during configuration clean-up" + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    log.severe("Error during configuration clean-up" + e.getMessage());
                }
                this.configure();
                FacesContext facesContext = FacesContext.getCurrentInstance();
                Application application = facesContext.getApplication();
                application.publishEvent(facesContext, PostConstructApplicationEvent.class, Application.class, (Object)application);
            }
        }
    }

    private void purgeConfiguration() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] NO_PARAMETER_TYPES = new Class[]{};
        Object[] NO_PARAMETERS = new Object[]{};
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Method appFactoryPurgeMethod = applicationFactory.getClass().getMethod("purgeApplication", NO_PARAMETER_TYPES);
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        Method renderKitPurgeMethod = renderKitFactory.getClass().getMethod("purgeRenderKit", NO_PARAMETER_TYPES);
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Method lifecyclePurgeMethod = lifecycleFactory.getClass().getMethod("purgeLifecycle", NO_PARAMETER_TYPES);
        appFactoryPurgeMethod.invoke((Object)applicationFactory, NO_PARAMETERS);
        renderKitPurgeMethod.invoke((Object)renderKitFactory, NO_PARAMETERS);
        RuntimeConfig.getCurrentInstance(this._externalContext).purge();
        lifecyclePurgeMethod.invoke((Object)lifecycleFactory, NO_PARAMETERS);
    }

    public void configure() throws FacesException {
        boolean metadataComplete = false;
        try {
            this.feedStandardConfig();
            this.feedMetaInfServicesFactories();
            ArrayList<FacesConfig> appConfigResources = new ArrayList<FacesConfig>();
            this.addClassloaderConfigurations(appConfigResources);
            this.addContextSpecifiedConfig(appConfigResources);
            FacesConfig webAppFacesConfig = this.getWebAppConfig();
            metadataComplete = webAppFacesConfig != null ? Boolean.valueOf(webAppFacesConfig.getMetadataComplete()) : false;
            this.orderAndFeedArtifacts(appConfigResources, webAppFacesConfig);
            if (log.isLoggable(Level.INFO)) {
                this.logMetaInf();
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        catch (SAXException e) {
            throw new FacesException((Throwable)e);
        }
        this.configureFactories();
        this.configureApplication();
        this.configureRenderKits();
        this.getAnnotationConfigurator().configure(((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication(), this.getDispenser(), metadataComplete);
        this.configureRuntimeConfig();
        this.configureLifecycle();
        this.handleSerialFactory();
        this.configureManagedBeanDestroyer();
        lastUpdate = System.currentTimeMillis();
    }

    private void feedStandardConfig() throws IOException, SAXException {
        InputStream stream;
        if (MyfacesConfig.getCurrentInstance(this._externalContext).isValidateXML()) {
            URL url = ClassUtils.getContextClassLoader().getResource(STANDARD_FACES_CONFIG_RESOURCE);
            if (url == null) {
                url = this.getClass().getResource(STANDARD_FACES_CONFIG_RESOURCE);
            }
            if (url != null) {
                this.validateFacesConfig(url);
            }
        }
        if ((stream = ClassUtils.getResourceAsStream(STANDARD_FACES_CONFIG_RESOURCE)) == null) {
            throw new FacesException("Standard faces config META-INF/standard-faces-config.xml not found");
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Reading standard config META-INF/standard-faces-config.xml");
        }
        this.getDispenser().feed(this.getUnmarshaller().getFacesConfig(stream, STANDARD_FACES_CONFIG_RESOURCE));
        stream.close();
    }

    protected void logMetaInf() {
        try {
            HashMap<String, List<JarInfo>> libs = new HashMap<String, List<JarInfo>>(30);
            Iterator it = ClassUtils.getResources("META-INF/MANIFEST.MF", this);
            while (it.hasNext()) {
                Version version;
                String path;
                JarInfo newInfo;
                URL url = (URL)it.next();
                Matcher matcher = REGEX_LIBRARY_PATTERN.matcher(url.toString());
                if (!matcher.matches()) continue;
                String artifactId = matcher.group(7);
                ArrayList<JarInfo> versions = (ArrayList<JarInfo>)libs.get(artifactId);
                if (versions == null) {
                    versions = new ArrayList<JarInfo>(2);
                    libs.put(artifactId, versions);
                }
                if (versions.contains(newInfo = new JarInfo(path = matcher.group(6), version = new Version(matcher.group(8), matcher.group(10), matcher.group(12), matcher.group(14), matcher.group(15))))) continue;
                versions.add(newInfo);
            }
            if (log.isLoggable(Level.INFO)) {
                if (log.isLoggable(Level.WARNING)) {
                    for (String artifactId : ARTIFACTS_IDS) {
                        List versions = (List)libs.get(artifactId);
                        if (versions == null || versions.size() <= 1) continue;
                        StringBuilder builder = new StringBuilder(1024);
                        builder.append("You are using the library: ");
                        builder.append(artifactId);
                        builder.append(" in different versions; first (and probably used) version is: ");
                        builder.append(((JarInfo)versions.get(0)).getVersion());
                        builder.append(" loaded from: ");
                        builder.append(((JarInfo)versions.get(0)).getUrl());
                        builder.append(", but also found the following versions: ");
                        boolean needComma = false;
                        for (int i = 1; i < versions.size(); ++i) {
                            JarInfo info = (JarInfo)versions.get(i);
                            if (needComma) {
                                builder.append(", ");
                            }
                            builder.append(info.getVersion());
                            builder.append(" loaded from: ");
                            builder.append(info.getUrl());
                            needComma = true;
                        }
                        log.warning(builder.toString());
                    }
                }
                for (String artifactId : ARTIFACTS_IDS) {
                    this.startLib(artifactId, libs);
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    protected void feedMetaInfServicesFactories() {
        try {
            for (String factoryName : FACTORY_NAMES) {
                Iterator it = ClassUtils.getResources(META_INF_SERVICES_RESOURCE_PREFIX + factoryName, this);
                while (it.hasNext()) {
                    String className;
                    URL url = (URL)it.next();
                    InputStream stream = this.openStreamWithoutCache(url);
                    InputStreamReader isr = new InputStreamReader(stream);
                    BufferedReader br = new BufferedReader(isr);
                    try {
                        className = br.readLine();
                    }
                    catch (IOException e) {
                        throw new FacesException("Unable to read class name from file " + url.toExternalForm(), (Throwable)e);
                    }
                    finally {
                        if (br != null) {
                            br.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Found " + factoryName + " factory implementation: " + className);
                    }
                    if (factoryName.equals("javax.faces.application.ApplicationFactory")) {
                        this.getDispenser().feedApplicationFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.ExternalContextFactory")) {
                        this.getDispenser().feedExternalContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.FacesContextFactory")) {
                        this.getDispenser().feedFacesContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.lifecycle.LifecycleFactory")) {
                        this.getDispenser().feedLifecycleFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.render.RenderKitFactory")) {
                        this.getDispenser().feedRenderKitFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.PartialViewContextFactory")) {
                        this.getDispenser().feedPartialViewContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.component.visit.VisitContextFactory")) {
                        this.getDispenser().feedVisitContextFactory(className);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected factory name " + factoryName);
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private InputStream openStreamWithoutCache(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClassloaderConfigurations(List<FacesConfig> appConfigResources) {
        try {
            FacesConfigResourceProvider provider = FacesConfigResourceProviderFactory.getFacesConfigResourceProviderFactory(this._externalContext).createFacesConfigResourceProvider(this._externalContext);
            Collection<URL> facesConfigs = provider.getMetaInfConfigurationResources(this._externalContext);
            for (URL url : facesConfigs) {
                if (MyfacesConfig.getCurrentInstance(this._externalContext).isValidateXML()) {
                    this.validateFacesConfig(url);
                }
                InputStream stream = null;
                try {
                    stream = this.openStreamWithoutCache(url);
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Reading config : " + url.toExternalForm());
                    }
                    appConfigResources.add(this.getUnmarshaller().getFacesConfig(stream, url.toExternalForm()));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private void addContextSpecifiedConfig(List<FacesConfig> appConfigResources) throws IOException, SAXException {
        for (String systemId : this.getConfigFilesList()) {
            InputStream stream;
            URL url;
            if (MyfacesConfig.getCurrentInstance(this._externalContext).isValidateXML() && (url = this._externalContext.getResource(systemId)) != null) {
                this.validateFacesConfig(url);
            }
            if ((stream = this._externalContext.getResourceAsStream(systemId)) == null) {
                log.severe("Faces config resource " + systemId + " not found");
                continue;
            }
            if (log.isLoggable(Level.INFO)) {
                log.info("Reading config " + systemId);
            }
            appConfigResources.add(this.getUnmarshaller().getFacesConfig(stream, systemId));
            stream.close();
        }
    }

    private List<String> getConfigFilesList() {
        String configFiles = this._externalContext.getInitParameter("javax.faces.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_FACES_CONFIG.equals(systemId)) {
                    if (!log.isLoggable(Level.WARNING)) continue;
                    log.warning("/WEB-INF/faces-config.xml has been specified in the javax.faces.CONFIG_FILES context parameter of the deployment descriptor. This will automatically be removed, if we wouldn't do this, it would be loaded twice.  See JSF spec 1.1, 10.3.2");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    private FacesConfig getWebAppConfig() throws IOException, SAXException {
        InputStream stream;
        URL url;
        FacesConfig webAppConfig = null;
        if (MyfacesConfig.getCurrentInstance(this._externalContext).isValidateXML() && (url = this._externalContext.getResource(DEFAULT_FACES_CONFIG)) != null) {
            this.validateFacesConfig(url);
        }
        if ((stream = this._externalContext.getResourceAsStream(DEFAULT_FACES_CONFIG)) != null) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Reading config /WEB-INF/faces-config.xml");
            }
            webAppConfig = this.getUnmarshaller().getFacesConfig(stream, DEFAULT_FACES_CONFIG);
            stream.close();
        }
        return webAppConfig;
    }

    private void validateFacesConfig(URL url) throws IOException, SAXException {
        String version = ConfigFilesXmlValidationUtils.getFacesConfigVersion(url);
        if ("1.2".equals(version) || "2.0".equals(version)) {
            ConfigFilesXmlValidationUtils.validateFacesConfigFile(url, this._externalContext, version);
        }
    }

    protected void orderAndFeedArtifacts(List<FacesConfig> appConfigResources, FacesConfig webAppConfig) throws FacesException {
        if (webAppConfig != null && webAppConfig.getAbsoluteOrdering() != null) {
            if (webAppConfig.getOrdering() != null && log.isLoggable(Level.WARNING)) {
                log.warning("<ordering> element found in application faces config. This description will be ignored and the actions described in <absolute-ordering> element will be taken into account instead.");
            }
            ArrayList<FacesConfig> othersResources = new ArrayList<FacesConfig>();
            List<OrderSlot> slots = webAppConfig.getAbsoluteOrdering().getOrderList();
            for (FacesConfig resource : appConfigResources) {
                if (resource.getName() != null && (resource.getName() == null || this.containsResourceInSlot(slots, resource.getName()))) continue;
                othersResources.add(resource);
            }
            for (OrderSlot slot : webAppConfig.getAbsoluteOrdering().getOrderList()) {
                if (slot instanceof ConfigOthersSlot) {
                    for (FacesConfig resource : othersResources) {
                        this.getDispenser().feed(resource);
                    }
                    continue;
                }
                FacesConfigNameSlot nameSlot = (FacesConfigNameSlot)slot;
                this.getDispenser().feed(this.getFacesConfig(appConfigResources, nameSlot.getName()));
            }
        } else if (!appConfigResources.isEmpty()) {
            for (FacesConfig resource : appConfigResources) {
                if (resource.getAbsoluteOrdering() == null || !log.isLoggable(Level.WARNING)) continue;
                log.warning("<absolute-ordering> element found in application configuration resource " + resource.getName() + ". " + "This description will be ignored and the actions described " + "in <ordering> elements will be taken into account instead.");
            }
            List<FacesConfig> postOrderedList = this.getPostOrderedList(appConfigResources);
            List<FacesConfig> sortedList = this.sortRelativeOrderingList(postOrderedList);
            if (sortedList == null) {
                sortedList = this.applySortingAlgorithm(appConfigResources);
            }
            for (FacesConfig resource : sortedList) {
                this.getDispenser().feed(resource);
            }
        }
        if (webAppConfig != null) {
            this.getDispenser().feed(webAppConfig);
        }
    }

    protected List<FacesConfig> applySortingAlgorithm(List<FacesConfig> appConfigResources) throws FacesException {
        Vertex<FacesConfig> v;
        ArrayList vertexList = new ArrayList();
        for (FacesConfig config : appConfigResources) {
            v = null;
            v = config.getName() != null ? new Vertex<FacesConfig>(config.getName(), config) : new Vertex<FacesConfig>(config);
            vertexList.add(v);
        }
        boolean[] referencedVertex = new boolean[vertexList.size()];
        for (int i = 0; i < vertexList.size(); ++i) {
            int j;
            Vertex v1;
            v = (Vertex<FacesConfig>)vertexList.get(i);
            FacesConfig f = v.getNode();
            if (f.getOrdering() == null) continue;
            for (OrderSlot slot : f.getOrdering().getBeforeList()) {
                String string;
                if (!(slot instanceof FacesConfigNameSlot) || (v1 = (Vertex)vertexList.get(j = DirectedAcyclicGraphVerifier.findVertex(vertexList, string = ((FacesConfigNameSlot)slot).getName()))) == null) continue;
                referencedVertex[i] = true;
                referencedVertex[j] = true;
                v1.addDependency(v);
            }
            for (OrderSlot slot : f.getOrdering().getAfterList()) {
                String string;
                if (!(slot instanceof FacesConfigNameSlot) || (v1 = (Vertex)vertexList.get(j = DirectedAcyclicGraphVerifier.findVertex(vertexList, string = ((FacesConfigNameSlot)slot).getName()))) == null) continue;
                referencedVertex[i] = true;
                referencedVertex[j] = true;
                v.addDependency(v1);
            }
        }
        ArrayList<Vertex> beforeAfterOthersList = new ArrayList<Vertex>();
        ArrayList<Vertex> othersList = new ArrayList<Vertex>();
        ArrayList referencedList = new ArrayList();
        for (int i = 0; i < vertexList.size(); ++i) {
            if (!referencedVertex[i]) {
                Vertex v2 = (Vertex)vertexList.get(i);
                FacesConfig facesConfig = (FacesConfig)v2.getNode();
                boolean added = false;
                if (facesConfig.getOrdering() != null) {
                    if (!facesConfig.getOrdering().getBeforeList().isEmpty()) {
                        added = true;
                        beforeAfterOthersList.add(v2);
                    } else if (!facesConfig.getOrdering().getAfterList().isEmpty()) {
                        added = true;
                        beforeAfterOthersList.add(v2);
                    }
                }
                if (added) continue;
                othersList.add(v2);
                continue;
            }
            referencedList.add(vertexList.get(i));
        }
        try {
            DirectedAcyclicGraphVerifier.topologicalSort(referencedList);
        }
        catch (CyclicDependencyException e) {
            e.printStackTrace();
        }
        ArrayList<FacesConfig> sortedList = new ArrayList<FacesConfig>();
        for (Vertex vertex : referencedList) {
            sortedList.add((FacesConfig)vertex.getNode());
        }
        for (Vertex vertex : othersList) {
            sortedList.add((FacesConfig)vertex.getNode());
        }
        for (Vertex vertex : beforeAfterOthersList) {
            FacesConfig f = (FacesConfig)vertex.getNode();
            boolean added = false;
            if (f.getOrdering() != null && !f.getOrdering().getBeforeList().isEmpty()) {
                added = true;
                sortedList.add(0, f);
            }
            if (added) continue;
            sortedList.add(f);
        }
        for (int i = 0; i < sortedList.size(); ++i) {
            int j;
            boolean founded;
            String name;
            FacesConfig facesConfig = (FacesConfig)sortedList.get(i);
            if (facesConfig.getOrdering() == null) continue;
            for (OrderSlot slot : facesConfig.getOrdering().getBeforeList()) {
                if (!(slot instanceof FacesConfigNameSlot) || (name = ((FacesConfigNameSlot)slot).getName()) == null || "".equals(name)) continue;
                founded = false;
                for (j = i - 1; j >= 0; --j) {
                    if (!name.equals(((FacesConfig)sortedList.get(j)).getName())) continue;
                    founded = true;
                    break;
                }
                if (!founded) continue;
                log.severe("Circular references detected when sorting application config resources. Use absolute ordering instead.");
                throw new FacesException("Circular references detected when sorting application config resources. Use absolute ordering instead.");
            }
            for (OrderSlot slot : facesConfig.getOrdering().getAfterList()) {
                if (!(slot instanceof FacesConfigNameSlot) || (name = ((FacesConfigNameSlot)slot).getName()) == null || "".equals(name)) continue;
                founded = false;
                for (j = i + 1; j < sortedList.size(); ++j) {
                    if (!name.equals(((FacesConfig)sortedList.get(j)).getName())) continue;
                    founded = true;
                    break;
                }
                if (!founded) continue;
                log.severe("Circular references detected when sorting application config resources. Use absolute ordering instead.");
                throw new FacesException("Circular references detected when sorting application config resources. Use absolute ordering instead.");
            }
        }
        return sortedList;
    }

    protected List<FacesConfig> sortRelativeOrderingList(List<FacesConfig> preOrderedList) {
        FacesConfig resource;
        int i;
        ArrayList<FacesConfig> sortedList = new ArrayList<FacesConfig>();
        for (i = 0; i < preOrderedList.size(); ++i) {
            resource = preOrderedList.get(i);
            if (resource.getOrdering() != null) {
                if (resource.getOrdering().getBeforeList().isEmpty() && resource.getOrdering().getAfterList().isEmpty()) {
                    sortedList.add(resource);
                    continue;
                }
                if (resource.getOrdering().getBeforeList().isEmpty()) {
                    this.applyAfterRule(sortedList, resource);
                    continue;
                }
                if (resource.getOrdering().getAfterList().isEmpty()) {
                    boolean referenceNode = false;
                    block1: for (int j = i + 1; j < preOrderedList.size(); ++j) {
                        FacesConfig pointingResource = preOrderedList.get(j);
                        for (OrderSlot slot : pointingResource.getOrdering().getBeforeList()) {
                            if (slot instanceof FacesConfigNameSlot && resource.getName().equals(((FacesConfigNameSlot)slot).getName())) {
                                referenceNode = true;
                            }
                            if (!(slot instanceof ConfigOthersSlot)) continue;
                            referenceNode = false;
                            break;
                        }
                        if (referenceNode) break;
                        for (OrderSlot slot : pointingResource.getOrdering().getAfterList()) {
                            if (!(slot instanceof FacesConfigNameSlot) || !resource.getName().equals(((FacesConfigNameSlot)slot).getName())) continue;
                            referenceNode = true;
                            continue block1;
                        }
                    }
                    this.applyBeforeRule(sortedList, resource, referenceNode);
                    continue;
                }
                int beforeWeight = 0;
                int afterWeight = 0;
                for (OrderSlot slot : resource.getOrdering().getBeforeList()) {
                    if (!(slot instanceof FacesConfigNameSlot)) continue;
                    ++beforeWeight;
                }
                for (OrderSlot slot : resource.getOrdering().getAfterList()) {
                    if (!(slot instanceof FacesConfigNameSlot)) continue;
                    ++afterWeight;
                }
                if (beforeWeight >= afterWeight) {
                    this.applyBeforeRule(sortedList, resource, false);
                    continue;
                }
                this.applyAfterRule(sortedList, resource);
                continue;
            }
            sortedList.add(resource);
        }
        for (i = 0; i < sortedList.size(); ++i) {
            String name;
            resource = (FacesConfig)sortedList.get(i);
            if (resource.getOrdering() == null) continue;
            for (OrderSlot slot : resource.getOrdering().getBeforeList()) {
                if (!(slot instanceof FacesConfigNameSlot) || (name = ((FacesConfigNameSlot)slot).getName()) == null || "".equals(name)) continue;
                boolean founded = false;
                for (int j = i - 1; j >= 0; --j) {
                    if (!name.equals(((FacesConfig)sortedList.get(j)).getName())) continue;
                    founded = true;
                    break;
                }
                if (!founded) continue;
                return null;
            }
            for (OrderSlot slot : resource.getOrdering().getAfterList()) {
                if (!(slot instanceof FacesConfigNameSlot) || (name = ((FacesConfigNameSlot)slot).getName()) == null || "".equals(name)) continue;
                boolean founded = false;
                for (int j = i + 1; j < sortedList.size(); ++j) {
                    if (!name.equals(((FacesConfig)sortedList.get(j)).getName())) continue;
                    founded = true;
                    break;
                }
                if (!founded) continue;
                return null;
            }
        }
        return sortedList;
    }

    private void applyBeforeRule(List<FacesConfig> sortedList, FacesConfig resource, boolean referenced) throws FacesException {
        boolean configOthers = false;
        ArrayList<String> names = new ArrayList<String>();
        for (OrderSlot slot : resource.getOrdering().getBeforeList()) {
            if (slot instanceof ConfigOthersSlot) {
                configOthers = true;
                break;
            }
            FacesConfigNameSlot nameSlot = (FacesConfigNameSlot)slot;
            names.add(nameSlot.getName());
        }
        if (configOthers) {
            if (resource.getOrdering().getBeforeList().size() > 1) {
                sortedList.add(0, resource);
            } else if (!referenced) {
                sortedList.add(0, resource);
            } else {
                sortedList.add(resource);
            }
        } else {
            boolean founded = false;
            for (int i = 0; i < sortedList.size(); ++i) {
                if (!names.contains(sortedList.get(i).getName())) continue;
                sortedList.add(i, resource);
                founded = true;
                break;
            }
            if (!founded) {
                sortedList.add(resource);
            }
        }
    }

    private void applyAfterRule(List<FacesConfig> sortedList, FacesConfig resource) throws FacesException {
        boolean configOthers = false;
        ArrayList<String> names = new ArrayList<String>();
        for (OrderSlot slot : resource.getOrdering().getAfterList()) {
            if (slot instanceof ConfigOthersSlot) {
                configOthers = true;
                break;
            }
            FacesConfigNameSlot nameSlot = (FacesConfigNameSlot)slot;
            names.add(nameSlot.getName());
        }
        if (configOthers) {
            sortedList.add(resource);
        } else {
            boolean founded = false;
            for (int i = sortedList.size() - 1; i >= 0; --i) {
                if (!names.contains(sortedList.get(i).getName())) continue;
                if (i + 1 < sortedList.size()) {
                    sortedList.add(i + 1, resource);
                } else {
                    sortedList.add(resource);
                }
                founded = true;
                break;
            }
            if (!founded) {
                sortedList.add(resource);
            }
        }
    }

    protected List<FacesConfig> getPostOrderedList(List<FacesConfig> appConfigResources) throws FacesException {
        ArrayList<String> availableReferences = new ArrayList<String>();
        for (FacesConfig resource : appConfigResources) {
            String name = resource.getName();
            if (name == null || "".equals(name)) continue;
            availableReferences.add(name);
        }
        for (FacesConfig resource : appConfigResources) {
            String name;
            OrderSlot slot;
            Ordering ordering = resource.getOrdering();
            if (ordering == null) continue;
            Iterator<OrderSlot> it = resource.getOrdering().getBeforeList().iterator();
            while (it.hasNext()) {
                slot = it.next();
                if (!(slot instanceof FacesConfigNameSlot) || availableReferences.contains(name = ((FacesConfigNameSlot)slot).getName())) continue;
                it.remove();
            }
            it = resource.getOrdering().getAfterList().iterator();
            while (it.hasNext()) {
                slot = it.next();
                if (!(slot instanceof FacesConfigNameSlot) || availableReferences.contains(name = ((FacesConfigNameSlot)slot).getName())) continue;
                it.remove();
            }
        }
        List<FacesConfig> appFilteredConfigResources = null;
        if (appConfigResources instanceof ArrayList) {
            appFilteredConfigResources = (List)((ArrayList)appConfigResources).clone();
        } else {
            appFilteredConfigResources = new ArrayList();
            appFilteredConfigResources.addAll(appConfigResources);
        }
        Collections.sort(appFilteredConfigResources, new Comparator<FacesConfig>(){

            @Override
            public int compare(FacesConfig o1, FacesConfig o2) {
                int o1Weight = 0;
                int o2Weight = 0;
                if (o1.getOrdering() != null) {
                    for (OrderSlot slot : o1.getOrdering().getBeforeList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++o1Weight;
                    }
                    for (OrderSlot slot : o1.getOrdering().getAfterList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++o1Weight;
                    }
                }
                if (o2.getOrdering() != null) {
                    for (OrderSlot slot : o2.getOrdering().getBeforeList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++o2Weight;
                    }
                    for (OrderSlot slot : o2.getOrdering().getAfterList()) {
                        if (!(slot instanceof FacesConfigNameSlot)) continue;
                        ++o2Weight;
                    }
                }
                return o2Weight - o1Weight;
            }
        });
        LinkedList<FacesConfig> postOrderedList = new LinkedList<FacesConfig>();
        ArrayList<FacesConfig> othersList = new ArrayList<FacesConfig>();
        ArrayList<String> nameBeforeStack = new ArrayList<String>();
        ArrayList<String> nameAfterStack = new ArrayList<String>();
        boolean[] visitedSlots = new boolean[appFilteredConfigResources.size()];
        for (int i = 0; i < appFilteredConfigResources.size(); ++i) {
            if (visitedSlots[i]) continue;
            this.resolveConflicts(appFilteredConfigResources, i, visitedSlots, nameBeforeStack, nameAfterStack, postOrderedList, othersList, false);
        }
        postOrderedList.addAll(othersList);
        return postOrderedList;
    }

    private void resolveConflicts(List<FacesConfig> appConfigResources, int index, boolean[] visitedSlots, List<String> nameBeforeStack, List<String> nameAfterStack, List<FacesConfig> postOrderedList, List<FacesConfig> othersList, boolean indexReferenced) throws FacesException {
        FacesConfig facesConfig = appConfigResources.get(index);
        if (nameBeforeStack.contains(facesConfig.getName())) {
            return;
        }
        if (nameAfterStack.contains(facesConfig.getName())) {
            return;
        }
        if (facesConfig.getOrdering() != null) {
            FacesConfig resource;
            boolean alreadyAdded;
            FacesConfigNameSlot nameSlot;
            boolean pointingResource = false;
            for (OrderSlot slot : facesConfig.getOrdering().getBeforeList()) {
                if (!(slot instanceof FacesConfigNameSlot)) continue;
                nameSlot = (FacesConfigNameSlot)slot;
                alreadyAdded = false;
                for (FacesConfig res : postOrderedList) {
                    if (!nameSlot.getName().equals(res.getName())) continue;
                    alreadyAdded = true;
                    break;
                }
                if (!alreadyAdded) {
                    int indexSlot = -1;
                    for (int i = 0; i < appConfigResources.size(); ++i) {
                        resource = appConfigResources.get(i);
                        if (resource.getName() == null || !nameSlot.getName().equals(resource.getName())) continue;
                        indexSlot = i;
                        break;
                    }
                    if (indexSlot == -1) continue;
                    pointingResource = true;
                    nameBeforeStack.add(facesConfig.getName());
                    this.resolveConflicts(appConfigResources, indexSlot, visitedSlots, nameBeforeStack, nameAfterStack, postOrderedList, othersList, true);
                    nameBeforeStack.remove(facesConfig.getName());
                    continue;
                }
                pointingResource = true;
            }
            for (OrderSlot slot : facesConfig.getOrdering().getAfterList()) {
                if (!(slot instanceof FacesConfigNameSlot)) continue;
                nameSlot = (FacesConfigNameSlot)slot;
                alreadyAdded = false;
                for (FacesConfig res : postOrderedList) {
                    if (!nameSlot.getName().equals(res.getName())) continue;
                    alreadyAdded = true;
                    break;
                }
                if (!alreadyAdded) {
                    int indexSlot = -1;
                    for (int i = 0; i < appConfigResources.size(); ++i) {
                        resource = appConfigResources.get(i);
                        if (resource.getName() == null || !nameSlot.getName().equals(resource.getName())) continue;
                        indexSlot = i;
                        break;
                    }
                    if (indexSlot == -1) continue;
                    pointingResource = true;
                    nameAfterStack.add(facesConfig.getName());
                    this.resolveConflicts(appConfigResources, indexSlot, visitedSlots, nameBeforeStack, nameAfterStack, postOrderedList, othersList, true);
                    nameAfterStack.remove(facesConfig.getName());
                    continue;
                }
                pointingResource = true;
            }
            if (facesConfig.getOrdering().getBeforeList().isEmpty() && facesConfig.getOrdering().getAfterList().isEmpty()) {
                postOrderedList.add(0, appConfigResources.get(index));
            } else if (pointingResource || indexReferenced) {
                postOrderedList.add(appConfigResources.get(index));
            } else {
                othersList.add(appConfigResources.get(index));
            }
        } else {
            postOrderedList.add(0, appConfigResources.get(index));
        }
        visitedSlots[index] = true;
    }

    private FacesConfig getFacesConfig(List<FacesConfig> appConfigResources, String name) {
        for (FacesConfig cfg : appConfigResources) {
            if (cfg.getName() == null || !name.equals(cfg.getName())) continue;
            return cfg;
        }
        return null;
    }

    private boolean containsResourceInSlot(List<OrderSlot> slots, String name) {
        for (OrderSlot slot : slots) {
            FacesConfigNameSlot nameSlot;
            if (!(slot instanceof FacesConfigNameSlot) || !name.equals((nameSlot = (FacesConfigNameSlot)slot).getName())) continue;
            return true;
        }
        return false;
    }

    private void configureFactories() {
        FacesConfigDispenser<FacesConfig> dispenser = this.getDispenser();
        this.setFactories("javax.faces.application.ApplicationFactory", dispenser.getApplicationFactoryIterator(), DEFAULT_APPLICATION_FACTORY);
        this.setFactories("javax.faces.context.ExceptionHandlerFactory", dispenser.getExceptionHandlerFactoryIterator(), DEFAULT_EXCEPTION_HANDLER_FACTORY);
        this.setFactories("javax.faces.context.ExternalContextFactory", dispenser.getExternalContextFactoryIterator(), DEFAULT_EXTERNAL_CONTEXT_FACTORY);
        this.setFactories("javax.faces.context.FacesContextFactory", dispenser.getFacesContextFactoryIterator(), DEFAULT_FACES_CONTEXT_FACTORY);
        this.setFactories("javax.faces.lifecycle.LifecycleFactory", dispenser.getLifecycleFactoryIterator(), DEFAULT_LIFECYCLE_FACTORY);
        this.setFactories("javax.faces.render.RenderKitFactory", dispenser.getRenderKitFactoryIterator(), DEFAULT_RENDER_KIT_FACTORY);
        this.setFactories("javax.faces.view.facelets.TagHandlerDelegateFactory", dispenser.getTagHandlerDelegateFactoryIterator(), DEFAULT_TAG_HANDLER_DELEGATE_FACTORY);
        this.setFactories("javax.faces.context.PartialViewContextFactory", dispenser.getPartialViewContextFactoryIterator(), DEFAULT_PARTIAL_VIEW_CONTEXT_FACTORY);
        this.setFactories("javax.faces.component.visit.VisitContextFactory", dispenser.getVisitContextFactoryIterator(), DEFAULT_VISIT_CONTEXT_FACTORY);
        this.setFactories("javax.faces.view.ViewDeclarationLanguageFactory", dispenser.getViewDeclarationLanguageFactoryIterator(), DEFAULT_VIEW_DECLARATION_LANGUAGE_FACTORY);
    }

    private void setFactories(String factoryName, Collection<String> factories, String defaultFactory) {
        FactoryFinder.setFactory((String)factoryName, (String)defaultFactory);
        for (String factory : factories) {
            if (factory.equals(defaultFactory)) continue;
            FactoryFinder.setFactory((String)factoryName, (String)factory);
        }
    }

    private void startLib(String artifactId, Map<String, List<JarInfo>> libs) {
        List<JarInfo> versions = libs.get(artifactId);
        if (versions == null) {
            log.info("MyFaces-package : " + artifactId + " not found.");
        } else {
            JarInfo info = versions.get(0);
            log.info("Starting up MyFaces-package : " + artifactId + " in version : " + info.getVersion() + " from path : " + info.getUrl());
        }
    }

    private void configureApplication() {
        Application application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        FacesConfigDispenser<FacesConfig> dispenser = this.getDispenser();
        application.setActionListener((ActionListener)this.getApplicationObject(ActionListener.class, dispenser.getActionListenerIterator(), null));
        if (dispenser.getDefaultLocale() != null) {
            application.setDefaultLocale(LocaleUtils.toLocale(dispenser.getDefaultLocale()));
        }
        if (dispenser.getDefaultRenderKitId() != null) {
            application.setDefaultRenderKitId(dispenser.getDefaultRenderKitId());
        }
        if (dispenser.getMessageBundle() != null) {
            application.setMessageBundle(dispenser.getMessageBundle());
        }
        application.setNavigationHandler(this.getApplicationObject(NavigationHandler.class, ConfigurableNavigationHandler.class, BackwardsCompatibleNavigationHandlerWrapper.class, dispenser.getNavigationHandlerIterator(), application.getNavigationHandler()));
        application.setStateManager(this.getApplicationObject(StateManager.class, dispenser.getStateManagerIterator(), application.getStateManager()));
        application.setResourceHandler(this.getApplicationObject(ResourceHandler.class, dispenser.getResourceHandlerIterator(), application.getResourceHandler()));
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String locale : dispenser.getSupportedLocalesIterator()) {
            locales.add(LocaleUtils.toLocale(locale));
        }
        application.setSupportedLocales(locales);
        application.setViewHandler(this.getApplicationObject(ViewHandler.class, dispenser.getViewHandlerIterator(), application.getViewHandler()));
        for (SystemEventListener systemEventListener : dispenser.getSystemEventListeners()) {
            try {
                Class eventClass = ClassUtils.classForName(systemEventListener.getSystemEventClass() != null ? systemEventListener.getSystemEventClass() : SystemEvent.class.getName());
                application.subscribeToEvent(eventClass, ClassUtils.classForName(systemEventListener.getSourceClass() != null ? systemEventListener.getSourceClass() : this.getDefaultSourcClassForSystemEvent(eventClass)), (javax.faces.event.SystemEventListener)ClassUtils.newInstance(systemEventListener.getSystemEventListenerClass()));
            }
            catch (ClassNotFoundException e) {
                log.log(Level.SEVERE, "System event listener could not be initialized, reason:", e);
            }
        }
        for (String componentType : dispenser.getComponentTypes()) {
            application.addComponent(componentType, dispenser.getComponentClass(componentType));
        }
        for (String converterId : dispenser.getConverterIds()) {
            application.addConverter(converterId, dispenser.getConverterClassById(converterId));
        }
        for (String converterClass : dispenser.getConverterClasses()) {
            try {
                application.addConverter(ClassUtils.simpleClassForName(converterClass), dispenser.getConverterClassByClass(converterClass));
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Converter could not be added. Reason:", ex);
            }
        }
        if (application instanceof ApplicationImpl) {
            for (String converterClassName : dispenser.getConverterConfigurationByClassName()) {
                ApplicationImpl app = (ApplicationImpl)application;
                app.addConverterConfiguration(converterClassName, dispenser.getConverterConfiguration(converterClassName));
            }
        }
        for (String validatorId : dispenser.getValidatorIds()) {
            application.addValidator(validatorId, dispenser.getValidatorClass(validatorId));
        }
        String beanValidatorDisabled = this._externalContext.getInitParameter("javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR");
        boolean defaultBeanValidatorDisabled = beanValidatorDisabled != null && beanValidatorDisabled.toLowerCase().equals("true");
        boolean beanValidatorInstalledProgrammatically = false;
        if (!defaultBeanValidatorDisabled && ExternalSpecifications.isBeanValidationAvailable()) {
            application.addDefaultValidatorId("javax.faces.Bean");
            beanValidatorInstalledProgrammatically = true;
        }
        for (String validatorId : dispenser.getDefaultValidatorIds()) {
            application.addDefaultValidatorId(validatorId);
        }
        if (!beanValidatorInstalledProgrammatically && application.getDefaultValidatorInfo().containsKey("javax.faces.Bean")) {
            if (!ExternalSpecifications.isBeanValidationAvailable()) {
                log.log(Level.WARNING, "The BeanValidator was installed as a default-validator from a faces-config file, but bean validation is not available on the classpath, thus it will not work!");
            } else if (defaultBeanValidatorDisabled) {
                log.log(Level.INFO, "The BeanValidator was disabled as a default-validator via the config parameter javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR in web.xml, but a faces-config file added it, thus it actually was installed as a default-validator.");
            }
        }
        for (Behavior behavior : dispenser.getBehaviors()) {
            application.addBehavior(behavior.getBehaviorId(), behavior.getBehaviorClass());
        }
        RuntimeConfig runtimeConfig = this.getRuntimeConfig();
        runtimeConfig.setPropertyResolverChainHead(this.getApplicationObject(PropertyResolver.class, dispenser.getPropertyResolverIterator(), new DefaultPropertyResolver()));
        runtimeConfig.setVariableResolverChainHead(this.getApplicationObject(VariableResolver.class, dispenser.getVariableResolverIterator(), new VariableResolverImpl()));
    }

    String getDefaultSourcClassForSystemEvent(Class systemEventClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constr : constructors = systemEventClass.getConstructors()) {
            Class<?>[] parms = constr.getParameterTypes();
            if (parms == null || parms.length != 1) continue;
            return parms[0].getName();
        }
        log.warning("The SystemEvent source type for " + systemEventClass.getName() + " could not be detected, either register it manually or use a constructor argument for auto detection, defaulting now to java.lang.Object");
        return "java.lang.Object";
    }

    protected RuntimeConfig getRuntimeConfig() {
        if (this._runtimeConfig == null) {
            this._runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        }
        return this._runtimeConfig;
    }

    public void setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this._runtimeConfig = runtimeConfig;
    }

    private <T> T getApplicationObject(Class<T> interfaceClass, Collection<String> classNamesIterator, T defaultObject) {
        return this.getApplicationObject(interfaceClass, null, null, classNamesIterator, defaultObject);
    }

    private <T> T getApplicationObject(Class<T> interfaceClass, Class<? extends T> extendedInterfaceClass, Class<? extends T> extendedInterfaceWrapperClass, Collection<String> classNamesIterator, T defaultObject) {
        Object current = defaultObject;
        for (String implClassName : classNamesIterator) {
            Class implClass = ClassUtils.simpleClassForName(implClassName);
            if (!interfaceClass.isAssignableFrom(implClass)) {
                throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
            }
            if (current == null) {
                current = ClassUtils.newInstance(implClass);
                continue;
            }
            Object newCurrent = null;
            try {
                Constructor delegationConstructor = null;
                if (extendedInterfaceClass != null && extendedInterfaceClass.isAssignableFrom(current.getClass())) {
                    try {
                        delegationConstructor = implClass.getConstructor(extendedInterfaceClass);
                    }
                    catch (NoSuchMethodException mnfe) {
                        // empty catch block
                    }
                }
                if (delegationConstructor == null) {
                    delegationConstructor = implClass.getConstructor(interfaceClass);
                }
                try {
                    newCurrent = delegationConstructor.newInstance(current);
                }
                catch (InstantiationException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
            }
            catch (NoSuchMethodException e) {
                newCurrent = ClassUtils.newInstance(implClass);
            }
            if (extendedInterfaceWrapperClass != null && !extendedInterfaceClass.isAssignableFrom(newCurrent.getClass())) {
                try {
                    Constructor<T> wrapperConstructor = extendedInterfaceWrapperClass.getConstructor(interfaceClass, extendedInterfaceClass);
                    newCurrent = wrapperConstructor.newInstance(newCurrent, current);
                }
                catch (NoSuchMethodException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
                catch (InstantiationException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
            }
            current = newCurrent;
        }
        return (T)current;
    }

    private void configureRuntimeConfig() {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        FacesConfigDispenser<FacesConfig> dispenser = this.getDispenser();
        for (ManagedBean bean : dispenser.getManagedBeans()) {
            if (log.isLoggable(Level.WARNING) && runtimeConfig.getManagedBean(bean.getManagedBeanName()) != null) {
                log.warning("More than one managed bean w/ the name of '" + bean.getManagedBeanName() + "' - only keeping the last ");
            }
            runtimeConfig.addManagedBean(bean.getManagedBeanName(), bean);
        }
        this.removePurgedBeansFromSessionAndApplication(runtimeConfig);
        for (NavigationRule rule : dispenser.getNavigationRules()) {
            runtimeConfig.addNavigationRule(rule);
        }
        for (ResourceBundle bundle : dispenser.getResourceBundles()) {
            runtimeConfig.addResourceBundle(bundle);
        }
        for (String className : dispenser.getElResolvers()) {
            runtimeConfig.addFacesConfigElResolver((ELResolver)ClassUtils.newInstance(className, ELResolver.class));
        }
        runtimeConfig.setFacesVersion(dispenser.getFacesVersion());
    }

    private void removePurgedBeansFromSessionAndApplication(RuntimeConfig runtimeConfig) {
        Map<String, ManagedBean> oldManagedBeans = runtimeConfig.getManagedBeansNotReaddedAfterPurge();
        if (oldManagedBeans != null) {
            for (Map.Entry<String, ManagedBean> entry : oldManagedBeans.entrySet()) {
                ManagedBean bean = entry.getValue();
                String scope = bean.getManagedBeanScope();
                if (scope != null && scope.equalsIgnoreCase("session")) {
                    this._externalContext.getSessionMap().remove(entry.getKey());
                    continue;
                }
                if (scope == null || !scope.equalsIgnoreCase("application")) continue;
                this._externalContext.getApplicationMap().remove(entry.getKey());
            }
        }
        runtimeConfig.resetManagedBeansNotReaddedAfterPurge();
    }

    private void configureRenderKits() {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        FacesConfigDispenser<FacesConfig> dispenser = this.getDispenser();
        for (String renderKitId : dispenser.getRenderKitIds()) {
            Collection<String> renderKitClass = dispenser.getRenderKitClasses(renderKitId);
            if (renderKitClass.isEmpty()) {
                renderKitClass = new ArrayList<String>(1);
                renderKitClass.add(DEFAULT_RENDER_KIT_CLASS);
            }
            RenderKit renderKit = this.getApplicationObject(RenderKit.class, renderKitClass, null);
            for (Renderer element : dispenser.getRenderers(renderKitId)) {
                javax.faces.render.Renderer renderer;
                Collection<ClientBehaviorRenderer> clientBehaviorRenderers = dispenser.getClientBehaviorRenderers(renderKitId);
                try {
                    renderer = (javax.faces.render.Renderer)ClassUtils.newInstance(element.getRendererClass());
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "failed to configure class " + element.getRendererClass(), e);
                    continue;
                }
                renderKit.addRenderer(element.getComponentFamily(), element.getRendererType(), renderer);
                for (ClientBehaviorRenderer clientBehaviorRenderer : clientBehaviorRenderers) {
                    try {
                        javax.faces.render.ClientBehaviorRenderer behaviorRenderer = (javax.faces.render.ClientBehaviorRenderer)ClassUtils.newInstance(clientBehaviorRenderer.getRendererClass());
                        renderKit.addClientBehaviorRenderer(clientBehaviorRenderer.getRendererType(), behaviorRenderer);
                    }
                    catch (Throwable e) {
                        if (!log.isLoggable(Level.SEVERE)) continue;
                        log.log(Level.SEVERE, "failed to configure client behavior renderer class " + clientBehaviorRenderer.getRendererClass(), e);
                    }
                }
            }
            renderKitFactory.addRenderKit(renderKitId, renderKit);
        }
    }

    private void configureLifecycle() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lifecycleFactory.getLifecycle(this.getLifecycleId());
        for (String listenerClassName : this.getDispenser().getLifecyclePhaseListeners()) {
            try {
                lifecycle.addPhaseListener((PhaseListener)ClassUtils.newInstance(listenerClassName, PhaseListener.class));
            }
            catch (ClassCastException e) {
                log.severe("Class " + listenerClassName + " does not implement PhaseListener");
            }
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext.isProjectStage(ProjectStage.Development)) {
            lifecycle.addPhaseListener((PhaseListener)new DebugPhaseListener());
        }
    }

    private String getLifecycleId() {
        String id = this._externalContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (id != null) {
            return id;
        }
        return "DEFAULT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSerialFactory() {
        String serialProvider = this._externalContext.getInitParameter("org.apache.myfaces.SERIAL_FACTORY");
        SerialFactory serialFactory = null;
        if (serialProvider == null) {
            serialFactory = new DefaultSerialFactory();
        } else {
            try {
                serialFactory = (SerialFactory)ClassUtils.newInstance(serialProvider);
            }
            catch (ClassCastException e) {
                log.log(Level.SEVERE, "Make sure '" + serialProvider + "' implements the correct interface", e);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "", e);
            }
            finally {
                if (serialFactory == null) {
                    serialFactory = new DefaultSerialFactory();
                    log.severe("Using default serialization provider");
                }
            }
        }
        log.info("Serialization provider : " + serialFactory.getClass());
        this._externalContext.getApplicationMap().put("org.apache.myfaces.SERIAL_FACTORY", serialFactory);
    }

    private void configureManagedBeanDestroyer() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map applicationMap = externalContext.getApplicationMap();
        Application application = facesContext.getApplication();
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        LifecycleProvider lifecycleProvider = LifecycleProviderFactory.getLifecycleProviderFactory().getLifecycleProvider(externalContext);
        ManagedBeanDestroyer mbDestroyer = new ManagedBeanDestroyer(lifecycleProvider, runtimeConfig);
        application.subscribeToEvent(PreDestroyCustomScopeEvent.class, (javax.faces.event.SystemEventListener)mbDestroyer);
        application.subscribeToEvent(PreDestroyViewMapEvent.class, (javax.faces.event.SystemEventListener)mbDestroyer);
        ManagedBeanDestroyerListener listener = (ManagedBeanDestroyerListener)applicationMap.get("org.apache.myfaces.ManagedBeanDestroyerListener");
        if (listener != null) {
            listener.setManagedBeanDestroyer(mbDestroyer);
        } else {
            log.log(Level.SEVERE, "No ManagedBeanDestroyerListener instance found, thus @PreDestroy methods won't get called in every case. This instance needs to be published before configuration is started.");
        }
    }

    static {
        ARTIFACTS_IDS = new String[]{MYFACES_API_PACKAGE_NAME, MYFACES_IMPL_PACKAGE_NAME, MYFACES_TOMAHAWK_PACKAGE_NAME, MYFACES_TOMAHAWK12_PACKAGE_NAME, MYFACES_TOMAHAWK_SANDBOX_PACKAGE_NAME, MYFACES_TOMAHAWK_SANDBOX12_PACKAGE_NAME, MYFACES_TOMAHAWK_SANDBOX15_PACKAGE_NAME, MYFACES_ORCHESTRA_PACKAGE_NAME, MYFACES_ORCHESTRA12_PACKAGE_NAME, MYFACES_TRINIDAD_API_PACKAGE_NAME, MYFACES_TRINIDAD_IMPL_PACKAGE_NAME, MYFACES_TOBAGO_PACKAGE_NAME, COMMONS_EL_PACKAGE_NAME, JSP_API_PACKAGE_NAME};
        REGEX_LIBRARY_PATTERN = Pattern.compile(REGEX_LIBRARY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Version
    implements Comparable<Version> {
        private Long[] parts = new Long[4];
        private boolean snapshot;

        public Version(String major, String minor, String maintenance, String extra, String snapshot) {
            this.parts[0] = Long.valueOf(major);
            if (minor != null) {
                this.parts[1] = Long.valueOf(minor);
                if (maintenance != null) {
                    this.parts[2] = Long.valueOf(maintenance);
                    if (extra != null) {
                        this.parts[3] = Long.valueOf(extra);
                    }
                }
            }
            this.snapshot = snapshot != null;
        }

        @Override
        public int compareTo(Version v) {
            for (int i = 0; i < this.parts.length; ++i) {
                Long left = this.parts[i];
                Long right = v.parts[i];
                if (left == null) {
                    if (right == null) break;
                    return -1;
                }
                if (right == null) {
                    return 1;
                }
                if (left < right) {
                    return -1;
                }
                if (left <= right) continue;
                return 1;
            }
            if (this.snapshot) {
                return v.snapshot ? 0 : -1;
            }
            return v.snapshot ? 1 : 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Version) {
                Version other = (Version)o;
                if (this.snapshot != other.snapshot) {
                    return false;
                }
                for (int i = 0; i < this.parts.length; ++i) {
                    Long thisPart = this.parts[i];
                    Long otherPart = other.parts[i];
                    if (!(thisPart == null ? otherPart != null : !thisPart.equals(otherPart))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            for (Long part : this.parts) {
                if (part == null) continue;
                hash ^= part.hashCode();
            }
            return hash ^= Boolean.valueOf(this.snapshot).hashCode();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.parts[0]);
            for (int i = 1; i < this.parts.length; ++i) {
                Long val = this.parts[i];
                if (val == null) continue;
                builder.append('.').append(val);
            }
            if (this.snapshot) {
                builder.append("-SNAPSHOT");
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JarInfo
    implements Comparable<JarInfo> {
        private String url;
        private Version version;

        public JarInfo(String url, Version version) {
            this.url = url;
            this.version = version;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getUrl() {
            return this.url;
        }

        @Override
        public int compareTo(JarInfo info) {
            return this.version.compareTo(info.version);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof JarInfo) {
                JarInfo other = (JarInfo)o;
                return this.version.equals(other.version);
            }
            return false;
        }

        public int hashCode() {
            return this.version.hashCode();
        }
    }
}

