/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import org.apache.myfaces.view.facelets.AbstractFacelet;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.TemplateClient;
import org.apache.myfaces.view.facelets.TemplateContext;
import org.apache.myfaces.view.facelets.TemplateManager;
import org.apache.myfaces.view.facelets.el.DefaultVariableMapper;
import org.apache.myfaces.view.facelets.impl.TemplateContextImpl;
import org.apache.myfaces.view.facelets.tag.jsf.core.AjaxHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultFaceletContext
extends AbstractFaceletContext {
    private final FacesContext _faces;
    private final ELContext _ctx;
    private final AbstractFacelet _facelet;
    private final List<AbstractFacelet> _faceletHierarchy;
    private VariableMapper _varMapper;
    private FunctionMapper _fnMapper;
    private final Map<String, Integer> _ids;
    private final Map<Integer, Integer> _prefixes;
    private String _prefix;
    private final StringBuilder _uniqueIdBuilder = new StringBuilder(30);
    private final FaceletCompositionContext _mctx;
    private LinkedList<AjaxHandler> _ajaxHandlerStack;
    private final List<TemplateContext> _isolatedTemplateContext;
    private int _currentTemplateContext;

    public DefaultFaceletContext(DefaultFaceletContext ctx, AbstractFacelet facelet, boolean ccWrap) {
        this._ctx = ctx._ctx;
        this._ids = ctx._ids;
        this._prefixes = ctx._prefixes;
        this._faces = ctx._faces;
        this._fnMapper = ctx._fnMapper;
        this._varMapper = ctx._varMapper;
        this._faceletHierarchy = new ArrayList<AbstractFacelet>(ctx._faceletHierarchy.size() + 1);
        this._faceletHierarchy.addAll(ctx._faceletHierarchy);
        this._faceletHierarchy.add(facelet);
        this._facelet = facelet;
        this._mctx = ctx._mctx;
        this._ajaxHandlerStack = ccWrap ? null : ctx._ajaxHandlerStack;
        this._isolatedTemplateContext = ctx._isolatedTemplateContext;
        this._currentTemplateContext = ctx._currentTemplateContext;
        ctx.getFacesContext().getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", this);
    }

    public DefaultFaceletContext(FacesContext faces, AbstractFacelet facelet, FaceletCompositionContext mctx) {
        this._ctx = faces.getELContext();
        this._ids = new HashMap<String, Integer>();
        this._prefixes = new HashMap<Integer, Integer>();
        this._faces = faces;
        this._fnMapper = this._ctx.getFunctionMapper();
        this._varMapper = this._ctx.getVariableMapper();
        if (this._varMapper == null) {
            this._varMapper = new DefaultVariableMapper();
        }
        this._faceletHierarchy = new ArrayList<AbstractFacelet>(1);
        this._faceletHierarchy.add(facelet);
        this._facelet = facelet;
        this._mctx = mctx;
        this._isolatedTemplateContext = new ArrayList<TemplateContext>(1);
        this._isolatedTemplateContext.add(new TemplateContextImpl());
        this._currentTemplateContext = 0;
        faces.getAttributes().put("com.sun.faces.facelets.FACELET_CONTEXT", this);
    }

    public FacesContext getFacesContext() {
        return this._faces;
    }

    public ExpressionFactory getExpressionFactory() {
        return this._facelet.getExpressionFactory();
    }

    public void setVariableMapper(VariableMapper varMapper) {
        this._varMapper = varMapper;
    }

    public void setFunctionMapper(FunctionMapper fnMapper) {
        this._fnMapper = fnMapper;
    }

    public void includeFacelet(UIComponent parent, String relativePath) throws IOException {
        this._facelet.include((AbstractFaceletContext)this, parent, relativePath);
    }

    public FunctionMapper getFunctionMapper() {
        return this._fnMapper;
    }

    public VariableMapper getVariableMapper() {
        return this._varMapper;
    }

    public Object getContext(Class key) {
        return this._ctx.getContext(key);
    }

    public void putContext(Class key, Object contextObject) {
        this._ctx.putContext(key, contextObject);
    }

    public String generateUniqueId(String base) {
        Integer cnt;
        if (this._prefix == null) {
            StringBuilder builder = new StringBuilder(this._faceletHierarchy.size() * 30);
            for (int i = 0; i < this._faceletHierarchy.size(); ++i) {
                AbstractFacelet facelet = this._faceletHierarchy.get(i);
                builder.append(facelet.getAlias());
            }
            Integer prefixInt = new Integer(Math.abs(builder.toString().hashCode()));
            Integer cnt2 = this._prefixes.get(prefixInt);
            if (cnt2 == null) {
                this._prefixes.put(prefixInt, new Integer(0));
                this._prefix = prefixInt.toString();
            } else {
                int i = cnt2 + 1;
                this._prefixes.put(prefixInt, new Integer(i));
                this._prefix = prefixInt + "_" + i;
            }
        }
        if ((cnt = this._ids.get(base)) == null) {
            this._ids.put(base, new Integer(0));
            this._uniqueIdBuilder.delete(0, this._uniqueIdBuilder.length());
            this._uniqueIdBuilder.append(this._prefix);
            this._uniqueIdBuilder.append("_");
            this._uniqueIdBuilder.append(base);
            return this._uniqueIdBuilder.toString();
        }
        int i = cnt + 1;
        this._ids.put(base, new Integer(i));
        this._uniqueIdBuilder.delete(0, this._uniqueIdBuilder.length());
        this._uniqueIdBuilder.append(this._prefix);
        this._uniqueIdBuilder.append("_");
        this._uniqueIdBuilder.append(base);
        this._uniqueIdBuilder.append("_");
        this._uniqueIdBuilder.append(i);
        return this._uniqueIdBuilder.toString();
    }

    public Object getAttribute(String name) {
        ValueExpression ve;
        if (this._varMapper != null && (ve = this._varMapper.resolveVariable(name)) != null) {
            return ve.getValue((ELContext)this);
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        if (this._varMapper != null) {
            if (value == null) {
                this._varMapper.setVariable(name, null);
            } else {
                this._varMapper.setVariable(name, this._facelet.getExpressionFactory().createValueExpression(value, Object.class));
            }
        }
    }

    public void includeFacelet(UIComponent parent, URL absolutePath) throws IOException, FacesException, ELException {
        this._facelet.include((AbstractFaceletContext)this, parent, absolutePath);
    }

    public ELResolver getELResolver() {
        return this._ctx.getELResolver();
    }

    @Override
    public TemplateManager popClient(TemplateClient client) {
        return this._isolatedTemplateContext.get(this._currentTemplateContext).popClient();
    }

    @Override
    public void pushClient(TemplateClient client) {
        this._isolatedTemplateContext.get(this._currentTemplateContext).pushClient(this._facelet, client);
    }

    @Override
    public TemplateManager popExtendedClient(TemplateClient client) {
        return this._isolatedTemplateContext.get(this._currentTemplateContext).popExtendedClient();
    }

    @Override
    public void extendClient(TemplateClient client) {
        this._isolatedTemplateContext.get(this._currentTemplateContext).extendClient(this._facelet, client);
    }

    @Override
    public boolean includeDefinition(UIComponent parent, String name) throws IOException, FaceletException, FacesException, ELException {
        return this._isolatedTemplateContext.get(this._currentTemplateContext).includeDefinition(this, this._facelet, parent, name);
    }

    @Override
    public void pushCompositeComponentClient(TemplateClient client) {
        TemplateContextImpl itc = new TemplateContextImpl();
        ((TemplateContext)itc).setCompositeComponentClient(new CompositeComponentTemplateManager(this._facelet, client));
        this._isolatedTemplateContext.add(itc);
        ++this._currentTemplateContext;
    }

    @Override
    public void popCompositeComponentClient() {
        if (this._currentTemplateContext > 0) {
            this._isolatedTemplateContext.remove(this._currentTemplateContext);
            --this._currentTemplateContext;
        }
    }

    @Override
    public void pushTemplateContext(TemplateContext client) {
        this._isolatedTemplateContext.add(client);
        ++this._currentTemplateContext;
    }

    @Override
    public TemplateContext popTemplateContext() {
        if (this._currentTemplateContext > 0) {
            TemplateContext itc = this._isolatedTemplateContext.get(this._currentTemplateContext);
            this._isolatedTemplateContext.remove(this._currentTemplateContext);
            --this._currentTemplateContext;
            return itc;
        }
        return null;
    }

    @Override
    public boolean includeCompositeComponentDefinition(UIComponent parent, String name) throws IOException, FaceletException, FacesException, ELException {
        TemplateManager ccClient = this._isolatedTemplateContext.get(this._currentTemplateContext).getCompositeComponentClient();
        if (ccClient != null) {
            return ccClient.apply(this, parent, name);
        }
        return false;
    }

    public boolean isPropertyResolved() {
        return this._ctx.isPropertyResolved();
    }

    public void setPropertyResolved(boolean resolved) {
        this._ctx.setPropertyResolved(resolved);
    }

    @Override
    public void applyCompositeComponent(UIComponent parent, Resource resource) throws IOException, FaceletException, FacesException, ELException {
        this._facelet.applyCompositeComponent(this, parent, resource);
    }

    @Override
    public Iterator<AjaxHandler> getAjaxHandlers() {
        if (this._ajaxHandlerStack != null && !this._ajaxHandlerStack.isEmpty()) {
            return this._ajaxHandlerStack.iterator();
        }
        return null;
    }

    @Override
    public void popAjaxHandlerToStack() {
        if (this._ajaxHandlerStack != null && !this._ajaxHandlerStack.isEmpty()) {
            this._ajaxHandlerStack.removeFirst();
        }
    }

    @Override
    public void pushAjaxHandlerToStack(AjaxHandler parent) {
        if (this._ajaxHandlerStack == null) {
            this._ajaxHandlerStack = new LinkedList();
        }
        this._ajaxHandlerStack.addFirst(parent);
    }

    @Override
    public boolean isBuildingCompositeComponentMetadata() {
        return this._facelet.isBuildingCompositeComponentMetadata();
    }

    @Override
    public FaceletCompositionContext getFaceletCompositionContext() {
        return this._mctx;
    }

    private static final class CompositeComponentTemplateManager
    extends TemplateManager
    implements TemplateClient {
        private final AbstractFacelet _owner;
        protected final TemplateClient _target;
        private final Set<String> _names = new HashSet<String>();

        public CompositeComponentTemplateManager(AbstractFacelet owner, TemplateClient target) {
            this._owner = owner;
            this._target = target;
        }

        public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
            String testName;
            String string = testName = name != null ? name : "facelets._NULL_DEF_";
            if (this._names.contains(testName)) {
                return false;
            }
            this._names.add(testName);
            boolean found = false;
            found = this._target.apply(new DefaultFaceletContext((DefaultFaceletContext)ctx, this._owner, false), parent, name);
            this._names.remove(testName);
            return found;
        }

        public boolean equals(Object o) {
            return this._owner == o || this._target == o;
        }
    }
}

