<?php
  /* File : bubbleSort.php
   Author : BIE1
   Creation: September 2010
*/



  /* Executes a bubble sort.
   The array given as input is not touched
   Another array is returned
   the parameter $debug : true means that the array 
   is printed at each step.
  */
function bubbleSort($a,$debug){
  $length = count($a);
  for($i=0;$i<$length;$i++){
    if($debug){
      echo "Pass: $i <br>\n";
      echo "<table>";  
      printArray($a,-1,-1);
    }
    for($j=0;$j<$length-1;$j++){
      if($a[$j]>$a[$j+1]){
         $tmp = $a[$j];
         $a[$j]=$a[$j+1];
         $a[$j+1]=$tmp;
         if($debug){
           printArray($a,$j,$j+1);
         }
      }
    }
    if($debug){
      echo "</table>\n";
    }
  }
  // the sorted array is returned
  return $a;
}

/*
 This function prints an array inside a table.
 The function is used inside the algorithm to show the
 actual move
*/
function printArray($arr,$i1,$i2){
   $length = count($arr);
   echo "<tr>";
   for ($i=0;$i<$length;$i++){
      if($i == $i1 || $i == $i2){
         echo "<td class=\"yellow\">$arr[$i]</td>\n";
      }
      else{
         echo "<td>$arr[$i]</td>\n";
      }
   }
   echo "</tr>\n";
}


/*
 This function "displayArray($name,$arr)" is an alternative to the standard 
 PHP function 	print_r($arr) which is to verbose for our purpose;
 */
function displayArray($name,$arr){

  echo "$name = [";
  foreach($arr as $v){
    echo "$v, ";
  }
  echo "]<br>\n";

}


?>
