<?php
/*
 * Author : Christoph Isch (I3R)
 * Modifications : Emmanuel Benoist
 * Created on Mar 3, 2010
 * Modification : Sept. 30, 2010
 */
 class Quicksort {
  static function sort ($array,$debug){
    return Quicksort::sortRecursive($array,$debug,0);
  }
    static function sortRecursive ($array,$debug,$depth){
 		$less = array();
 		$equ = array();
 		$greater = array();
 		if (sizeof($array)<2){
		  if($debug){
		    Quicksort::printSpaces($depth);
		    Quicksort::displayArray('$res',$array);
		  }
		  return $array;
 		}
 		$pivot = Quicksort::selectPivot($array);
 		foreach($array as $val){
		  if ($val < $pivot){
		    array_push($less,$val);
		  }elseif($val == $pivot){
		    array_push($equ,$val);
		  }else{
		    array_push($greater,$val);
		  }
 		}
		if($debug){
		  print ('<p>');
		  Quicksort::printSpaces($depth);
		  print ("Sorting:");
		  Quicksort::printSpaces($depth);
		  Quicksort::displayArray('$array',$array);
		  Quicksort::printSpaces($depth);
		  print ("chose pivot:$pivot<br> ");
		  //print_r($less);
		  Quicksort::printSpaces($depth);
		  Quicksort::displayArray('$less',$less);
		  Quicksort::printSpaces($depth);
		  Quicksort::displayArray('$equ',$equ);
		  //print_r($greater);
		  Quicksort::printSpaces($depth);
		  Quicksort::displayArray('$greater',$greater);
		  print('</p>');
		}

		$res = array_merge(Quicksort::sortRecursive($less,$debug,$depth+1),$equ,
				   Quicksort::sortRecursive($greater,$debug,$depth+1));
		if($debug){
		  Quicksort::printSpaces($depth);
		  Quicksort::displayArray('$res',$res);
		}
 		return $res;
 	}
  
 	private static function selectPivot($array){
 		$index = rand(0,sizeof($array)-1);
 		return $array[$index];
 	}
	
	private static function displayArray($name,$arr){
	  
	  echo "$name = [";
	  foreach($arr as $v){
	    echo "$v, ";
	  }
	  echo "]<br>\n";
	  
	}

	private static function printSpaces($num){
	  for($i=0;$i<$num;$i++){
	    echo "&nbsp;&nbsp;&nbsp;";
	  }
	}
 }

?>
