<html>
<head><title>Bubble Sort Algorithm</title>
<link rel="stylesheet" href="../../style.css" type="text/css">
</head>
<body>
<?php

require_once('bubbleSort.php');
require_once('quickSort.php');
require_once('timer.php');

$minimum = 32;
$maximum_bubble = 5000;
$maximum_tests = 50000;

// This function generates an array with
// $size numbers.
function generateArray($size){
  $arr= array();
  for($i=0;$i<$size;$i++){
    $arr[]=rand(1,1000000);
  }
  return $arr;
}

$timer = new Timer();

for($i=$minimum;$i<=$maximum_tests;$i*=2){
  $a = generateArray($i);
  // If the size is reasonable, we measure the time of bubble sort
  if($i < $maximum_bubble){
    $timer->reset();
    $timer->start();

    $b = bubbleSort($a,0);

    $timer->stop();
    $time_bubble = $timer->getTimer();
  }

  // We measure the time of Quicksort
  $timer->reset();
  $timer->start();

  $a2= Quicksort::sort($a,0);
  $timer->stop();
  $time_quick = $timer->getTimer();


  // We measure the time of sort()
  $timer->reset();
  $timer->start();
  $a3 = sort($a);

  $timer->stop();
  $time_sort = $timer->getTimer();

  // We print all the results for the size $i
  // First Bubble sort (as long as it is available)
  // Second Quick sort
  // Finaly "sort()"
  print("<b>i=$i</b><br>");
  if($i < $maximum_bubble){
    print("bubbleSort = $time_bubble ");
    if(isset($old_time_bubble)){
      print (" (Ratio = ".$time_bubble/$old_time_bubble.")");
    }
    echo("<br>\n");
    $old_time_bubble = $time_bubble;
  }
  else{
    print("bubbleSort = <br>\n");
  }
  print("quickSort = $time_quick ");
  if(isset($old_time_quick)){
    print (" (Ratio = ".$time_quick/$old_time_quick.")");
  }
  echo("<br>\n");
  $old_time_quick = $time_quick;
  
  print("sort = $time_sort ");
  if(isset($old_time_sort)){
    print (" (Ratio = ".$time_sort/$old_time_sort.")");
  }
  echo("<br>\n");
  $old_time_sort = $time_sort;

 }


?>

</body>
