<?php


/********************************************************
 *  Class : Timer
 *  File  : timer.php
 *  Author : frc1
 *  Date : 2005/04/02 15:12:41
 *  History : Example modified by bie1 2009
 *  History : Example modified by bie1 2010 (removed the testing in
this file)
*********************************************************/

//error_reporting(E_PARSE); 

class Timer
{
    const DEBUG=FALSE;
    private $startTime;
    private $stopTime;
    private $elapsed;
    private $stopped;


    public function __construct()
    {
	if(Timer::DEBUG){
	    echo "Entering the constructor of Timer class... <br>";
	}
	$this->startTime = 0.0;
	$this->stopTime = 0.0;
	$this->elapsed = 0.0;
	$this->stopped = TRUE;
	if(Timer::DEBUG){
	    echo "Leaving the constructor of Timer class... <br>";
	}
    }

  
    /* Starts or restart the timer */

    public function start()
    {   
	if(Timer::DEBUG){
	    echo "Entering in start method....<br>\n";
	}
	if ($this->stopped == TRUE) {
	    $this->startTime = microtime(TRUE);
	    $this->stopped = FALSE;
	} else {
	    // Do nothing, the counter is already started.... 
	}
	if(Timer::DEBUG){
	    echo "leaving start...<br>\n";
	}
    }
  
    /* Stops the timer and compute the elapsed time. To get this elapsed time, 
      use the getTimer() method 
     */

    public function stop()
    {
	if(Timer::DEBUG){
	    echo "entering stop... <br>";
	}
	if ($this->stopped == FALSE ) {

	    $this->stopTime = microtime(TRUE);
	    $this->elapsed += $this->stopTime - $this->startTime;
	    $this->stopped = TRUE;
	} else {
	    //Do nothing, timer already stopped...
	}
	if(Timer::DEBUG){
	    echo "leaving stop...<br>";
	}
    }

    /* Gets the current value of the counter. This method should only be 
      called after the timer has been stopped 
    */
    

    /* Returns the total elapsed time for this counter */
    public function getTimer()
    {
	return $this->elapsed;
    }

    /* resets the counter */
    public function reset() {
	$this->elapsed = 0.0;
	$this->startTime = 0.0;
	$this->stopped = TRUE;
    }

    /* returns the current elapsed time, without stopping the timer */
    public function lap() 
    {
	if(Timer::DEBUG){
	    echo "entering lap...<br>";
	}
	return ( $this->elapsed + (microtime(TRUE) - $this->startTime) );
    }

}



?>

</body>