<?php


echo "test class.... <br>";
$myTimer2 = new Timer();
echo "Starting a timer...<br>";

$myTimer2->start();

echo "timer2 is started...<br>";

$myTimer2->stop();

echo "timer2 stopped... <br>";

echo "timer2->value : " . $myTimer2->getTimer() . "\n";



/********************************************************
 *  Class : Timer
 *  File  : timer.php
 *  Author : frc
 *  Date : 2005/04/02 15:12:41
 *  CVS  : $Header: /var/cvsreps/projects/c420/i-php.d/web/examples/base/timer.phps,v 1.1 2005/04/18 04:04:07 frc Exp $
 *  History :
 *********************************************************/

//error_reporting(E_PARSE); 

class Timer
{

    private $startTime;
    private $stopTime;
    private $elapsed;
    private $stopped;


    public function __construct()
    {
	echo "Entering the constructor of Timer class... <br>";
	$this->startTime = 0.0;
	$this->stopTime = 0.0;
	$this->elapsed = 0.0;
	$this->stopped = TRUE;
	echo "Leaving the constructor of Timer class... <br>";
    }

  
    /* Starts or restart the timer */

    public function start()
    {   
	echo "Entering in start method....\n";

	if ($this->stopped == TRUE) {
	    $this->startTime = microtime(TRUE);
	    $this->stopped = FALSE;
	} else {
	    // Do nothing, the counter is already started.... 
	}
	
	echo "leaving start...\n";
    }
  
    /* Stops the timer and compute the elapsed time. To get this elapsed time, 
      use the getTimer() method 
     */

    public function stop()
    {
	echo "entering stop... <br>";
	if ($this->stopped == FALSE ) {

	    $this->stopTime = microtime(TRUE);
	    $this->elapsed += $this->stopTime - $this->startTime;
	    $this->stopped = TRUE;
	} else {
	    //Do nothing, timer already stopped...
	}
	
	echo "leaving stop...<br>";
    }

    /* Gets the current value of the counter. This method should only be 
      called after the timer has been stopped 
    */
    

    /* Returns the total elapsed time for this counter */
    public function getTimer()
    {
	return $this->elapsed;
    }

    /* resets the counter */
    public function reset() {
	$this->startTime = 0.0;
	$this->stopped = FALSE;
    }

    /* returns the current elapsed time, without stopping the timer */
    public function lap() 
    {
	echo "entering lap...<br>";
	return ( $this->elapsed + (microtime(TRUE) - $this->startTime) );
    }

}


$myTimer = new Timer();
echo "Starting a timer 2...<br>";
$myTimer->start();
echo "Timer is now running (I hope)...<br>";
echo "Timer lap time is : " . $myTimer->lap() . "<br>";
echo "It is now time to stop the timer... <br>";
$myTimer->stop();
echo "The elapsed time for our little story is : " . $myTimer->getTimer() . "<br>";


?>